/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.machines;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.render.Textures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DrumRenderer
implements TextureUtils.IIconRegister {
    private final String basePath;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[] textures;

    public DrumRenderer(String basePath) {
        this.basePath = basePath;
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        String formattedBase = "gregtech:blocks/" + this.basePath;
        this.textures = new TextureAtlasSprite[3];
        this.textures[0] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/top"));
        this.textures[1] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/side"));
        this.textures[2] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/bottom"));
    }

    public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, EnumFacing rotation) {
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            TextureAtlasSprite baseSprite = renderSide == EnumFacing.UP ? this.textures[0] : (renderSide == EnumFacing.DOWN ? this.textures[2] : this.textures[1]);
            Textures.renderFace((CCRenderState)renderState, (Matrix4)translation, (IVertexOperation[])pipeline, (EnumFacing)renderSide, (Cuboid6)Cuboid6.full, (TextureAtlasSprite)baseSprite);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.textures[0];
    }
}

