/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common.world;

import com.therandomlabs.randomtweaks.RTConfig;
import com.therandomlabs.randomtweaks.common.world.WorldTypeVoid;
import com.therandomlabs.randomtweaks.common.world.WorldTypeVoidIslands;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class WorldHandler {
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        GameRules gameRules = world.func_82736_K();
        String netherPortalCreation = RTConfig.misc.disableNetherPortalCreationGameRuleName;
        String fallDamage = RTConfig.misc.fallDamageMultiplierGameRuleName;
        if (!netherPortalCreation.isEmpty() && !gameRules.func_82765_e(netherPortalCreation)) {
            gameRules.func_82764_b(netherPortalCreation, "false");
        }
        if (!fallDamage.isEmpty() && !gameRules.func_82765_e(fallDamage)) {
            gameRules.func_82764_b(fallDamage, "1.0");
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.Clone event) {
        WorldHandler.onPlayerSpawn(event.getEntityPlayer());
    }

    @SubscribeEvent
    public static void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        WorldHandler.onPlayerSpawn(event.getEntityPlayer());
    }

    private static void onPlayerSpawn(EntityPlayer player) {
        World world = player.func_130014_f_();
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return;
        }
        WorldType type = world.func_175624_G();
        if (type instanceof WorldTypeVoid) {
            WorldHandler.onPlayerSpawnInVoidWorld(player, false);
        } else if (type instanceof WorldTypeVoidIslands) {
            WorldHandler.onPlayerSpawnInVoidWorld(player, true);
        }
    }

    private static void onPlayerSpawnInVoidWorld(EntityPlayer player, boolean voidIslands) {
        int newSpawnY;
        World world = player.func_130014_f_();
        BlockPos playerSpawnPoint = player.getBedLocation(DimensionType.OVERWORLD.func_186068_a());
        boolean shouldSetWorldSpawn = false;
        if (playerSpawnPoint == null) {
            playerSpawnPoint = world.func_175694_M();
            shouldSetWorldSpawn = true;
        }
        if (WorldHandler.isSpawnable(world, world.func_175672_r(playerSpawnPoint))) {
            return;
        }
        if (voidIslands) {
            BlockPos pos = world.func_175672_r(new BlockPos(0, 0, 0));
            newSpawnY = pos.func_177956_o() + 1;
        } else {
            newSpawnY = RTConfig.voidWorld.ySpawn;
        }
        BlockPos newSpawn = new BlockPos(0, newSpawnY, 0);
        player.func_70107_b(0.5, (double)newSpawnY, 0.5);
        player.func_180473_a(newSpawn, true);
        if (shouldSetWorldSpawn) {
            world.func_175652_B(newSpawn);
        }
        if (voidIslands) {
            return;
        }
        BlockPos spawnBlock = new BlockPos(0, newSpawnY - 1, 0);
        if (WorldHandler.isSpawnable(world, spawnBlock)) {
            return;
        }
        world.func_175656_a(spawnBlock, RTConfig.voidWorld.blockState);
    }

    private static boolean isSpawnable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_185904_a().func_76230_c() && !state.func_177230_c().isFoliage((IBlockAccess)world, pos);
    }
}

