/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.RTConfig;
import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.util.FoodStats;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.hunger.ExhaustionEvent;

public class RTFoodStats
extends FoodStats {
    public RTFoodStats(FoodStats stats) {
        this.field_75127_a = stats.field_75127_a;
        this.field_75126_c = stats.field_75126_c;
        this.field_75125_b = stats.field_75125_b;
        this.field_75123_d = stats.field_75123_d;
    }

    public void func_75122_a(int foodLevel, float foodSaturationModifier) {
        Map.Entry<Integer, Float> stats = RTFoodStats.addStats(this.field_75127_a, this.field_75125_b, foodLevel, foodSaturationModifier);
        this.field_75127_a = stats.getKey();
        this.field_75125_b = stats.getValue().floatValue();
    }

    public void func_75113_a(float exhaustion) {
        super.func_75113_a(exhaustion * (float)RTConfig.hunger.exhaustionMultiplier);
    }

    public static Map.Entry<Integer, Float> addStats(int originalFoodLevel, float originalSaturation, int foodLevel, float foodSaturationModifier) {
        float maxSaturationLevel;
        int newFoodLevel = originalFoodLevel + foodLevel;
        float newSaturation = originalSaturation + (float)foodLevel * foodSaturationModifier * 2.0f;
        if (newFoodLevel > RTConfig.hunger.maximumHungerLevel) {
            if (RTConfig.hunger.carryExcessHungerToSaturation) {
                newSaturation += (float)(originalFoodLevel - RTConfig.hunger.maximumHungerLevel);
            }
            newFoodLevel = RTConfig.hunger.maximumHungerLevel;
        }
        if ((maxSaturationLevel = (float)newFoodLevel + (float)RTConfig.hunger.saturationLimit) == Float.NEGATIVE_INFINITY) {
            maxSaturationLevel = Float.MAX_VALUE;
        }
        newSaturation = Math.min(newSaturation, maxSaturationLevel);
        return new AbstractMap.SimpleEntry<Integer, Float>(newFoodLevel, Float.valueOf(newSaturation));
    }

    public static class AppleCoreEventHandler {
        @SubscribeEvent
        public void onFoodStatsAddition(FoodEvent.FoodStatsAddition event) {
            event.setCanceled(true);
            FoodStats stats = event.player.func_71024_bL();
            Map.Entry<Integer, Float> newStats = RTFoodStats.addStats(stats.field_75127_a, stats.field_75125_b, event.foodValuesToBeAdded.hunger, event.foodValuesToBeAdded.saturationModifier);
            stats.field_75127_a = newStats.getKey();
            stats.field_75125_b = newStats.getValue().floatValue();
        }

        @SubscribeEvent
        public void onExhaustionAddition(ExhaustionEvent.ExhaustionAddition event) {
            event.deltaExhaustion = (float)((double)event.deltaExhaustion * RTConfig.hunger.exhaustionMultiplier);
        }
    }
}

