/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.client;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.therandomlabs.randomtweaks.RTConfig;
import com.therandomlabs.randomtweaks.RandomTweaks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="randomtweaks")
public final class CapeHandler {
    public static final ResourceLocation CAPE_LOCATION = new ResourceLocation("randomtweaks", "textures/cape.png");
    public static final ImmutableList<String> CONTRIBUTORS = ImmutableList.of((Object)"de2b3ebd-c0e9-4f43-b0f7-b660d482dd51", (Object)"819eb301-e040-4580-9c63-3f98684f58bc", (Object)"1dbb2583-db0a-4c8a-b187-f62bdde4595d", (Object)"fc2c6552-9a1d-4d7e-b9c1-2fef96cacc6c");

    @SubscribeEvent
    public static void entityJoinWorld(EntityJoinWorldEvent event) {
        AbstractClientPlayer player;
        if (!RTConfig.client.contributorCapes) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof AbstractClientPlayer && CapeHandler.hasCape(player = (AbstractClientPlayer)entity)) {
            Minecraft.func_71410_x().func_152344_a(() -> CapeHandler.setCape(player));
        }
    }

    public static boolean hasCape(AbstractClientPlayer player) {
        return RandomTweaks.IS_DEOBFUSCATED || CONTRIBUTORS.contains((Object)player.func_110124_au().toString());
    }

    private static void setCape(AbstractClientPlayer player) {
        NetworkPlayerInfo info = player.func_175155_b();
        if (info == null) {
            return;
        }
        info.field_187107_a.put(MinecraftProfileTexture.Type.CAPE, CAPE_LOCATION);
        info.field_187107_a.put(MinecraftProfileTexture.Type.ELYTRA, CAPE_LOCATION);
    }
}

