/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import squeek.applecore.api.food.FoodEvent;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.compat.PacketDispatcher;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.foodtracker.foodqueue.FixedTimeQueue;
import squeek.spiceoflife.items.ItemFoodJournal;
import squeek.spiceoflife.network.PacketFoodEatenAllTime;
import squeek.spiceoflife.network.PacketFoodHistory;

public class FoodTracker {
    @SubscribeEvent
    public void onFoodEaten(FoodEvent.FoodEaten event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        FoodEaten foodEaten = new FoodEaten(event.food, event.player);
        foodEaten.foodValues = event.foodValues;
        FoodTracker.addFoodEatenByPlayer(foodEaten, event.player);
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(FoodHistory.CAPABILITY_ID, (ICapabilityProvider)new FoodHistory((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        FoodHistory foodHistory = FoodHistory.get((EntityPlayer)event.getEntityLiving());
        foodHistory.deltaTicksActive(1L);
        if (ModConfig.USE_TIME_QUEUE && !ModConfig.USE_HUNGER_QUEUE) {
            FixedTimeQueue timeQueue = (FixedTimeQueue)foodHistory.getHistory();
            timeQueue.prune(event.getEntityLiving().field_70170_p.func_82737_E(), foodHistory.ticksActive);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ModConfig.sync((EntityPlayerMP)event.player);
        FoodGroupRegistry.sync((EntityPlayerMP)event.player);
        FoodHistory foodHistory = FoodHistory.get(event.player);
        foodHistory.validate();
        FoodTracker.syncFoodHistory(foodHistory);
        if (!foodHistory.wasGivenFoodJournal && (ModConfig.GIVE_FOOD_JOURNAL_ON_START || ModConfig.GIVE_FOOD_JOURNAL_ON_DIMINISHING_RETURNS && ModConfig.FOOD_EATEN_THRESHOLD == 0)) {
            ItemFoodJournal.giveToPlayer(event.player);
            foodHistory.wasGivenFoodJournal = true;
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        FoodHistory foodHistory = FoodHistory.get(event.player);
        FoodTracker.syncFoodHistory(foodHistory);
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() || !(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        FoodHistory foodHistory = FoodHistory.get(player);
        foodHistory.writeToNBTData(null);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        FoodHistory foodHistory = FoodHistory.get(event.player);
        foodHistory.readFromNBTData(null);
        FoodTracker.syncFoodHistory(foodHistory);
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ModConfig.assumeClientOnly();
        }
    }

    public static void syncFoodHistory(FoodHistory foodHistory) {
        PacketDispatcher.get().sendTo(new PacketFoodEatenAllTime(foodHistory.totalFoodsEatenAllTime), (EntityPlayerMP)foodHistory.player);
        PacketDispatcher.get().sendTo(new PacketFoodHistory(foodHistory, true), (EntityPlayerMP)foodHistory.player);
    }

    public static boolean addFoodEatenByPlayer(FoodEaten foodEaten, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            PacketDispatcher.get().sendTo(new PacketFoodHistory(foodEaten), (EntityPlayerMP)player);
        }
        return FoodHistory.get(player).addFood(foodEaten);
    }

    public static int getFoodHistoryLengthInRelevantUnits(EntityPlayer player) {
        return FoodHistory.get(player).getHistoryLengthInRelevantUnits();
    }

    @Nonnull
    public static ItemStack getFoodLastEatenBy(EntityPlayer player) {
        return FoodHistory.get((EntityPlayer)player).getLastEatenFood().itemStack;
    }
}

