/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.process;

import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.util.RequesterReference;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.ItemHelper;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RequestItem
extends Request<ItemStack> {
    public RequestItem(RequesterReference<ItemStack> attachment) {
        super(attachment);
    }

    public RequestItem(RequesterReference<ItemStack> attachment, ItemStack stack) {
        super(attachment, stack.func_77946_l());
    }

    private RequestItem(RequesterReference<ItemStack> attachment, long id) {
        super(attachment, id);
    }

    public static NBTTagCompound writeNBT(Request<ItemStack> request) {
        NBTTagList stacks = new NBTTagList();
        for (Object stack : request.stacks) {
            stacks.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        NBTTagList blacklist = new NBTTagList();
        for (RequesterReference requesterReference : request.blacklist) {
            blacklist.func_74742_a((NBTBase)RequesterReference.writeNBT(requesterReference));
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("attachment", (NBTBase)RequesterReference.writeNBT(request.attachment));
        nbt.func_74782_a("stacks", (NBTBase)stacks);
        nbt.func_74782_a("blacklist", (NBTBase)blacklist);
        nbt.func_74772_a("id", request.id);
        return nbt;
    }

    public static RequestItem readNBT(NBTTagCompound nbt) {
        RequestItem request = new RequestItem(RequesterReference.readNBT(nbt.func_74775_l("attachment")), (long)nbt.func_74762_e("id"));
        NBTTagList stacks = nbt.func_150295_c("stacks", 10);
        for (int i = 0; i < stacks.func_74745_c(); ++i) {
            request.stacks.add(new ItemStack(stacks.func_150305_b(i)));
        }
        NBTTagList blacklist = nbt.func_150295_c("blacklist", 10);
        for (int i = 0; i < blacklist.func_74745_c(); ++i) {
            request.blacklist.add(RequesterReference.readNBT(blacklist.func_150305_b(i)));
        }
        return request;
    }

    public static void writePacket(PacketBase packet, Request<ItemStack> request) {
        RequesterReference.writePacket(packet, request.attachment);
        packet.addLong(request.id);
        packet.addInt(request.stacks.size());
        for (ItemStack stack : request.stacks) {
            packet.addItemStack(stack);
        }
    }

    public static RequestItem readPacket(PacketBase packet) {
        RequestItem request = new RequestItem(RequesterReference.readPacket(packet), packet.getLong());
        int size = packet.getInt();
        for (int i = 0; i < size; ++i) {
            request.stacks.add(packet.getItemStack());
        }
        return request;
    }

    @Override
    public void addStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        for (ItemStack s : this.stacks) {
            if (!ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)s)) continue;
            s.func_190917_f(stack.func_190916_E());
            return;
        }
        this.stacks.add(stack.func_77946_l());
    }

    @Override
    public void decreaseStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        Iterator iterator = this.stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack s = (ItemStack)iterator.next();
            if (!ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)s)) continue;
            s.func_190918_g(stack.func_190916_E());
            if (s.func_190926_b()) {
                iterator.remove();
            }
            return;
        }
    }

    @Override
    public int getCount(ItemStack stack) {
        for (ItemStack item : this.stacks) {
            if (!ItemHelper.itemsIdentical((ItemStack)item, (ItemStack)stack)) continue;
            return item.func_190916_E();
        }
        return 0;
    }
}

