/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import xreliquary.Reliquary;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.items.ItemMobCharm;
import xreliquary.reference.Settings;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true)
public class ItemMobCharmBelt
extends ItemBase
implements IBauble {
    private static final String SLOTS_TAG = "Slots";
    private static final String TYPE_TAG = "Type";
    private static final String DAMAGE_TAG = "Damage";

    public ItemMobCharmBelt() {
        super("mob_charm_belt");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.BELT;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack stack, EntityLivingBase player) {
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        player.openGui((Object)Reliquary.INSTANCE, 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public ItemStack getMobCharmInSlot(@Nonnull ItemStack belt, int slotIndex) {
        NBTTagCompound nbt = belt.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(SLOTS_TAG)) {
            return ItemStack.field_190927_a;
        }
        NBTTagList mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        if (mobCharms.func_74745_c() <= slotIndex) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound mobCharmNbt = (NBTTagCompound)mobCharms.func_179238_g(slotIndex);
        if (!mobCharmNbt.func_74764_b(TYPE_TAG) || !mobCharmNbt.func_74764_b(DAMAGE_TAG)) {
            this.removeMobCharmInSlot(belt, slotIndex);
            return ItemStack.field_190927_a;
        }
        ItemStack mobCharm = ItemMobCharm.getCharmStack(mobCharmNbt.func_74771_c(TYPE_TAG));
        mobCharm.func_77964_b(mobCharmNbt.func_74762_e(DAMAGE_TAG));
        return mobCharm;
    }

    public void putMobCharmInSlot(ItemStack belt, int slotIndex, ItemStack mobCharm) {
        NBTTagList mobCharms;
        if (mobCharm.func_190926_b()) {
            this.removeMobCharmInSlot(belt, slotIndex);
            return;
        }
        NBTTagCompound mobCharmNbt = new NBTTagCompound();
        mobCharmNbt.func_74774_a(TYPE_TAG, ModItems.mobCharm.getType(mobCharm));
        mobCharmNbt.func_74768_a(DAMAGE_TAG, mobCharm.func_77952_i());
        NBTTagCompound nbt = belt.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            mobCharms = new NBTTagList();
        } else {
            mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        }
        if (mobCharms.func_74745_c() < slotIndex) {
            return;
        }
        if (mobCharms.func_74745_c() == slotIndex) {
            mobCharms.func_74742_a((NBTBase)mobCharmNbt);
        } else {
            mobCharms.func_150304_a(slotIndex, (NBTBase)mobCharmNbt);
        }
        nbt.func_74782_a(SLOTS_TAG, (NBTBase)mobCharms);
        belt.func_77982_d(nbt);
    }

    public void removeMobCharmInSlot(ItemStack belt, int slotIndex) {
        NBTTagCompound nbt = belt.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(SLOTS_TAG)) {
            return;
        }
        NBTTagList mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        if (mobCharms.func_74745_c() <= slotIndex) {
            return;
        }
        mobCharms.func_74744_a(slotIndex);
    }

    public int getCharmCount(ItemStack belt) {
        NBTTagCompound nbt = belt.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        NBTTagList mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        return mobCharms.func_74745_c();
    }

    boolean hasCharmType(ItemStack belt, byte type) {
        NBTTagCompound nbt = belt.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(SLOTS_TAG)) {
            return false;
        }
        NBTTagList mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        for (int i = mobCharms.func_74745_c() - 1; i >= 0; --i) {
            NBTTagCompound mobCharmNbt = (NBTTagCompound)mobCharms.func_179238_g(i);
            if (!mobCharmNbt.func_74764_b(TYPE_TAG) || !mobCharmNbt.func_74764_b(DAMAGE_TAG)) {
                this.removeMobCharmInSlot(belt, i);
            }
            if (mobCharmNbt.func_74771_c(TYPE_TAG) != type) continue;
            return true;
        }
        return false;
    }

    int damageCharmType(ItemStack belt, byte type) {
        NBTTagCompound nbt = belt.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(SLOTS_TAG)) {
            return -1;
        }
        NBTTagList mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        for (int i = mobCharms.func_74745_c() - 1; i >= 0; --i) {
            NBTTagCompound mobCharmNbt = (NBTTagCompound)mobCharms.func_179238_g(i);
            if (!mobCharmNbt.func_74764_b(TYPE_TAG) || !mobCharmNbt.func_74764_b(DAMAGE_TAG)) {
                this.removeMobCharmInSlot(belt, i);
            }
            if (mobCharmNbt.func_74771_c(TYPE_TAG) != type) continue;
            int damage = mobCharmNbt.func_74762_e(DAMAGE_TAG);
            if (damage + Settings.Items.MobCharm.damagePerKill > ModItems.mobCharm.getMaxDamage(ItemStack.field_190927_a)) {
                this.removeMobCharmInSlot(belt, i);
                return ModItems.mobCharm.getMaxDamage(ItemStack.field_190927_a) + 1;
            }
            mobCharmNbt.func_74768_a(DAMAGE_TAG, damage += Settings.Items.MobCharm.damagePerKill);
            return damage;
        }
        return -1;
    }
}

