/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.MapLimiter;
import xaero.map.MapWriter;
import xaero.map.Misc;
import xaero.map.WorldMap;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.RegionDetection;
import xaero.map.graphics.TextureUploader;
import xaero.map.gui.GuiMap;
import xaero.map.pool.MapTilePool;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;

public class MapProcessor
implements Runnable {
    public static final int DEFAULT_LIGHT_LEVELS = 4;
    public static MapProcessor instance;
    private Exception crashedBy;
    private MapSaveLoad mapSaveLoad;
    private MapWriter mapWriter;
    private MapLimiter mapLimiter;
    private ByteBufferDeallocator bufferDeallocator;
    private TextureUploader textureUploader;
    private final Hashtable<String, Hashtable<Integer, Hashtable<Integer, MapRegion>>> currentMap = new Hashtable();
    private final Hashtable<String, List<MapRegion>> currentMapLists = new Hashtable();
    private final Hashtable<String, Hashtable<Integer, Hashtable<Integer, RegionDetection>>> detectedRegions = new Hashtable();
    private World world;
    private EntityPlayer player;
    private World newWorld;
    private EntityPlayer newPlayer;
    private ArrayList<Double[]> footprints = new ArrayList();
    private int footprintsTimer;
    private String lastWorld;
    private String lastWorldMainId;
    private String currentWorldString;
    private String currentWorldStringNoDim;
    private String currentDimension;
    private String currentWorldStringNoDimMainId;
    private String currentWorldStringNoDimMultiworldId;
    private BlockPos currentSpawn;
    private String newWorldStringNoDimMainId;
    private String newWorldStringNoDimMultiworldId;
    private String newDimension;
    public final Object renderThreadPauseSync = new Object();
    private int pauseUploading;
    private int pauseRendering;
    public final Object writerThreadPauseSync = new Object();
    private int pauseWriting;
    public final Object processorThreadPauseSync = new Object();
    private int pauseProcessing;
    public final Object loadingSync = new Object();
    private boolean waitingForWorldUpdate;
    private ArrayList<MapRegion> toProcess = new ArrayList();
    private ArrayList<MapRegion> toRefresh = new ArrayList();
    private ArrayList<Integer> texturesToDelete = new ArrayList();
    private ArrayList<Integer> buffersToDelete = new ArrayList();
    private ArrayList<Runnable> tasks = new ArrayList();
    private int lightLevel;
    private static final int SPAWNPOINT_TIMEOUT = 3000;
    private BlockPos spawnToRestore;
    private long terrainDownloadEnded = -1L;
    private long playerDeathTime = -1L;
    private MapTilePool tilePool;
    private OverlayManager overlayManager;
    private long renderStartTime;
    private Field scheduledTasksField;
    private Callable<Object> renderStartTimeUpdater;
    private String[] dimensionsToIgnore = new String[]{"FZHammer"};
    private String lastDimension = null;
    public Field selectedField = null;
    private HashMap<String, String> multiworldPointers = new HashMap();

    public MapProcessor(MapSaveLoad mapSaveLoad, MapWriter mapWriter, MapLimiter mapLimiter, ByteBufferDeallocator bufferDeallocator, MapTilePool tilePool, OverlayManager overlayManager, TextureUploader textureUploader) throws NoSuchFieldException {
        this.mapSaveLoad = mapSaveLoad;
        this.mapWriter = mapWriter;
        this.mapLimiter = mapLimiter;
        this.bufferDeallocator = bufferDeallocator;
        this.tilePool = tilePool;
        this.overlayManager = overlayManager;
        this.textureUploader = textureUploader;
        instance = this;
        try {
            this.scheduledTasksField = Minecraft.class.getDeclaredField("field_152351_aB");
        }
        catch (NoSuchFieldException e) {
            try {
                this.scheduledTasksField = Minecraft.class.getDeclaredField("scheduledTasks");
            }
            catch (NoSuchFieldException nsfe) {
                throw nsfe;
            }
            catch (SecurityException se) {
                throw se;
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        Runnable renderStartTimeUpdaterRunnable = new Runnable(){

            @Override
            public void run() {
                MapProcessor.this.updateRenderStartTime();
            }
        };
        this.renderStartTimeUpdater = Executors.callable(renderStartTimeUpdaterRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.crashedBy == null) {
                Object object = this.processorThreadPauseSync;
                synchronized (object) {
                    if (!this.isProcessingPaused()) {
                        this.updateWorld();
                        this.updatePlayer();
                        if (this.world != null) {
                            this.updateLighting(this.world);
                            if (this.player != null) {
                                this.updateFootprints(this.world, this.player, Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? 1 : 10);
                            }
                        }
                        if (this.currentWorldString != null) {
                            this.mapLimiter.applyLimit(this.getCurrentMapList(this.currentDimension));
                            for (int i = 0; i < this.toProcess.size(); ++i) {
                                MapRegion region = this.toProcess.get(i);
                                this.mapSaveLoad.updateSave(region);
                            }
                        }
                        this.mapSaveLoad.run(this.world);
                        this.handleRefresh(this.world);
                        while (!this.tasks.isEmpty()) {
                            Runnable task = this.tasks.remove(0);
                            task.run();
                        }
                    }
                }
                try {
                    Thread.sleep(this.world == null || Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? 100L : 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            this.crashedBy = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRenderProcess(Minecraft mc) throws RuntimeException {
        try {
            ArrayList<Integer> arrayList = this.renderThreadPauseSync;
            synchronized (arrayList) {
                if (this.pauseUploading == 0 && this.currentDimension != null) {
                    GL11.glGetError();
                    GlStateManager.func_187425_g((int)3317, (int)4);
                    GlStateManager.func_187425_g((int)3316, (int)0);
                    GlStateManager.func_187425_g((int)3315, (int)0);
                    GlStateManager.func_187425_g((int)3314, (int)0);
                    int debugFPS = Minecraft.func_175610_ah();
                    long uploadStart = System.nanoTime();
                    long passed = uploadStart - this.renderStartTime;
                    long time60FPS = 16666666L;
                    long totalTime = debugFPS <= 0 || debugFPS > 50 && debugFPS < 65 ? time60FPS : (long)(1000000000 / debugFPS);
                    long timeAvailable = Math.max(3000000L, totalTime - passed);
                    long uploadUntil = uploadStart + timeAvailable / 4L;
                    long gpuLimit = Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? Math.max(1000000L, totalTime * 5L / 12L) : Math.min(totalTime / 5L, timeAvailable);
                    boolean onlyCurrentLevel = true;
                    boolean shouldContinue = false;
                    for (int c = 0; c < 2 && gpuLimit > 0L; ++c) {
                        for (int i = 0; i < this.toProcess.size() && System.nanoTime() < uploadUntil; ++i) {
                            MapRegion region;
                            Object object = this.toProcess;
                            synchronized (object) {
                                if (i >= this.toProcess.size()) {
                                    break;
                                }
                                region = this.toProcess.get(i);
                            }
                            if (region == null || region.getWorld() == null || !region.getWorld().equals(this.currentWorldString)) continue;
                            object = region;
                            synchronized (object) {
                                if (region.getLoadState() < 4) {
                                    boolean allCleaned = true;
                                    boolean allCached = true;
                                    boolean allUploaded = true;
                                    for (int x = 0; x < 8; ++x) {
                                        for (int z = 0; z < 8; ++z) {
                                            MapTileChunk chunk = region.getChunk(x, z);
                                            if (chunk == null) continue;
                                            if (chunk.getLoadState() >= 2) {
                                                if (gpuLimit > 0L) {
                                                    MapTileChunk mapTileChunk = chunk;
                                                    synchronized (mapTileChunk) {
                                                        int toUpload;
                                                        if (!chunk.isUpdatingBuffers() && (toUpload = chunk.toUpload(this.getLightLevel(), onlyCurrentLevel)) != -1 && chunk.shouldUpload(toUpload)) {
                                                            if (chunk.getTimer() == 0) {
                                                                long estimatedGPUTime = chunk.uploadBuffer(this.textureUploader, toUpload);
                                                                gpuLimit -= estimatedGPUTime;
                                                                if (!chunk.shouldDownloadFromPBO()) {
                                                                    chunk.setToUpload(toUpload, false);
                                                                    if (chunk.getBufferFormat(toUpload) == -1) {
                                                                        chunk.deleteBuffer(toUpload);
                                                                    } else if (chunk.toUpload(this.getLightLevel(), false) == -1) {
                                                                        chunk.setCachePrepared(true);
                                                                    }
                                                                }
                                                            } else {
                                                                chunk.decTimer();
                                                            }
                                                        }
                                                    }
                                                }
                                                if (!(region.getLoadState() < 2 || region.isBeingWritten() || region.isRefreshing() || region.isWaitingForRegionBelow() || chunk.getLoadState() == 3)) {
                                                    region.setLoadState((byte)3);
                                                    chunk.setLoadState((byte)3);
                                                    chunk.clean();
                                                }
                                            }
                                            if (chunk.getLoadState() != 3) {
                                                allCleaned = false;
                                            }
                                            if (!chunk.isCachePrepared()) {
                                                allCached = false;
                                            }
                                            if (chunk.toUpload(this.getLightLevel(), false) == -1) continue;
                                            allUploaded = false;
                                        }
                                    }
                                    boolean bl = allUploaded = allUploaded && region.getLoadState() >= 2 && !region.isRefreshing();
                                    if (!allUploaded) {
                                        shouldContinue = true;
                                    }
                                    boolean bl2 = allCached = allCached && allUploaded;
                                    if ((!region.shouldCache() || !region.recacheHasBeenRequested()) && region.getLoadState() == 3 && allCleaned && allUploaded) {
                                        region.setLoadState((byte)4);
                                        region.destroyBufferUpdateObjects();
                                        region.deleteGLBuffers();
                                        ArrayList<MapRegion> arrayList2 = this.toProcess;
                                        synchronized (arrayList2) {
                                            if (i < this.toProcess.size()) {
                                                this.toProcess.remove(i);
                                                --i;
                                            }
                                        }
                                        if (WorldMap.settings.debug) {
                                            System.out.println("Region freed: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + this.mapWriter.getUpdateCounter() + " " + this.currentWorldString);
                                        }
                                    }
                                    if (allCached && !region.isAllCachePrepared()) {
                                        region.setAllCachePrepared(true);
                                    }
                                    if (region.shouldCache() && region.isAllCachePrepared()) {
                                        instance.getMapSaveLoad().requestCache(region);
                                    }
                                }
                                continue;
                            }
                        }
                        if (!shouldContinue) break;
                        onlyCurrentLevel = false;
                    }
                    this.textureUploader.uploadTextures();
                }
            }
            this.mapLimiter.updateAvailableVRAM();
            if (!this.texturesToDelete.isEmpty()) {
                arrayList = this.texturesToDelete;
                synchronized (arrayList) {
                    int[] obs = ArrayUtils.toPrimitive((Integer[])this.texturesToDelete.toArray(new Integer[0]));
                    ByteBuffer buffer = BufferUtils.createByteBuffer((int)(obs.length * 4));
                    IntBuffer bufferIntView = buffer.asIntBuffer();
                    bufferIntView.put(obs);
                    bufferIntView.flip();
                    GL11.glDeleteTextures((IntBuffer)bufferIntView);
                    this.bufferDeallocator.deallocate(buffer, WorldMap.settings.debug);
                    this.texturesToDelete.clear();
                }
            }
            if (!this.buffersToDelete.isEmpty()) {
                int[] obs = ArrayUtils.toPrimitive((Integer[])this.buffersToDelete.toArray(new Integer[0]));
                ByteBuffer buffer = BufferUtils.createByteBuffer((int)(obs.length * 4));
                IntBuffer bufferIntView = buffer.asIntBuffer();
                bufferIntView.put(obs);
                bufferIntView.flip();
                GL15.glDeleteBuffers((IntBuffer)bufferIntView);
                this.bufferDeallocator.deallocate(buffer, WorldMap.settings.debug);
                this.buffersToDelete.clear();
            }
            if (Minecraft.func_71410_x().func_71372_G() && Minecraft.func_71410_x().field_71474_y.field_74352_v) {
                GL11.glFinish();
            }
        }
        catch (Exception e) {
            this.crashedBy = e;
        }
        this.checkForCrashes();
    }

    public boolean ignoreWorld(World world) {
        for (int i = 0; i < this.dimensionsToIgnore.length; ++i) {
            if (!this.dimensionsToIgnore[i].equals(world.field_73011_w.func_186058_p().func_186065_b())) continue;
            return true;
        }
        return false;
    }

    private String getDimensionName(World world) {
        if (this.ignoreWorld(world)) {
            return this.lastDimension;
        }
        this.lastDimension = world.field_73011_w.getSaveFolder();
        return world.field_73011_w.getSaveFolder();
    }

    private String applyPointer(String actualMultiworld) {
        if (this.multiworldPointers.containsKey(actualMultiworld)) {
            return this.multiworldPointers.get(actualMultiworld);
        }
        return actualMultiworld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeWorld(World world, EntityPlayer player) {
        this.pushWriterPause();
        Object object = this.loadingSync;
        synchronized (object) {
            this.waitingForWorldUpdate = true;
        }
        this.newWorld = world;
        this.newPlayer = player;
        if (world == null) {
            this.currentSpawn = null;
            this.newWorldStringNoDimMainId = null;
            this.newWorldStringNoDimMultiworldId = null;
            this.newDimension = "null";
        } else {
            String newMultiworldId;
            Minecraft mc = Minecraft.func_71410_x();
            String[] newWorldArray = this.getNewWorld(mc);
            String newMainId = newWorldArray == null ? null : newWorldArray[0];
            String string = newMultiworldId = newWorldArray == null ? null : this.applyPointer(newWorldArray[1]);
            if (this.currentWorldStringNoDimMultiworldId != null && !this.currentWorldStringNoDimMultiworldId.equals(newMultiworldId) && this.playerDeathTime != -1L && System.currentTimeMillis() - this.playerDeathTime <= 1000L) {
                this.multiworldPointers.put(newMultiworldId, this.currentWorldStringNoDimMultiworldId);
                if (WorldMap.settings.debug) {
                    System.out.println("New pointer! " + newMultiworldId + " -> " + this.currentWorldStringNoDimMultiworldId);
                }
                newMultiworldId = this.currentWorldStringNoDimMultiworldId;
            }
            this.newWorldStringNoDimMainId = newMainId;
            this.newWorldStringNoDimMultiworldId = newMultiworldId;
            this.newDimension = this.getDimensionName(world);
            if (this.newDimension == null) {
                this.newDimension = "null";
            }
        }
        this.popWriterPause();
    }

    private String[] getNewWorld(Minecraft mc) {
        String[] result = new String[2];
        if (mc.func_71401_C() != null) {
            result[0] = mc.func_71401_C().func_71270_I().replaceAll("_", "^us^") + "_%DIMENSION%";
            result[1] = "";
        } else {
            result[1] = "_mw" + (this.currentSpawn.func_177958_n() >> 6) + "," + (this.currentSpawn.func_177956_o() >> 6) + "," + (this.currentSpawn.func_177952_p() >> 6);
            if (mc.func_147104_D() != null && this.currentSpawn != null) {
                String serverIP = mc.func_147104_D().field_78845_b;
                if (serverIP.contains(":")) {
                    serverIP = serverIP.substring(0, serverIP.indexOf(":"));
                }
                result[0] = "Multiplayer_" + serverIP.replaceAll(":", "\u00a7") + "_%DIMENSION%";
            } else if (mc.func_181540_al() && WorldMap.events.getLatestRealm() != null && this.currentSpawn != null) {
                result[0] = "Realms_" + WorldMap.events.getLatestRealm().ownerUUID + "." + WorldMap.events.getLatestRealm().id + "_%DIMENSION%";
            } else {
                return null;
            }
        }
        return result;
    }

    private void updatePlayer() {
        EntityPlayerSP actualPlayer = Minecraft.func_71410_x().field_71439_g;
        if (actualPlayer != this.player && actualPlayer.func_130014_f_() == this.world) {
            this.pushWriterPause();
            this.player = actualPlayer;
            if (WorldMap.settings.debug) {
                System.out.println("Player entity changed within the same world!");
            }
            this.popWriterPause();
        }
    }

    private synchronized void updateWorld() throws IOException {
        boolean isNewDimension;
        boolean isNewWorldMainId = this.currentWorldStringNoDimMainId == null && this.newWorldStringNoDimMainId != null || this.currentWorldStringNoDimMainId != null && !this.currentWorldStringNoDimMainId.equals(this.newWorldStringNoDimMainId);
        boolean isNewWorldMultiworldId = this.currentWorldStringNoDimMultiworldId == null && this.newWorldStringNoDimMultiworldId != null || this.currentWorldStringNoDimMultiworldId != null && !this.currentWorldStringNoDimMultiworldId.equals(this.newWorldStringNoDimMultiworldId);
        boolean isNewWorld = isNewWorldMainId || isNewWorldMultiworldId;
        boolean bl = isNewDimension = this.currentDimension == null && this.newDimension != null || this.currentDimension != null && !this.currentDimension.equals(this.newDimension);
        if (isNewWorld || isNewDimension) {
            boolean shouldDetect;
            boolean shouldResetPointers;
            this.pushRenderPause(true, true);
            this.pushWriterPause();
            String newWorldStringNoDim = this.newWorldStringNoDimMainId == null ? null : this.newWorldStringNoDimMainId + this.newWorldStringNoDimMultiworldId;
            boolean shouldClear = newWorldStringNoDim != null && (this.currentWorldStringNoDim != null || this.lastWorld == null || !this.lastWorld.equals(newWorldStringNoDim));
            boolean bl2 = shouldResetPointers = isNewWorldMainId && this.newWorldStringNoDimMainId != null && (this.currentWorldStringNoDimMainId != null || this.lastWorldMainId == null || !this.lastWorldMainId.equals(this.newWorldStringNoDimMainId));
            if (shouldResetPointers) {
                this.multiworldPointers.clear();
                this.playerDeathTime = -1L;
                if (WorldMap.settings.debug) {
                    System.out.println("Resetting multiworld pointers!");
                }
            }
            this.mapSaveLoad.getToSave().clear();
            for (List<MapRegion> dim : this.currentMapLists.values()) {
                for (MapRegion region : dim) {
                    if (region.recacheHasBeenRequested() && region.getCacheFile() != null) {
                        Files.deleteIfExists(region.getCacheFile().toPath());
                        if (WorldMap.settings.debug) {
                            System.out.println(String.format("Deleting cache for region %s because it might be outdated.", region));
                        }
                    }
                    region.setReloadHasBeenRequested(false, "world/dim change");
                    if (region.getLoadState() == 2) {
                        if (region.isRefreshing()) {
                            region.setRecacheHasBeenRequested(false, "world/dim change");
                            region.setRefreshing(false);
                        }
                        if (region.isBeingWritten()) {
                            this.mapSaveLoad.getToSave().add(region);
                        }
                    }
                    if (region.isRefreshing()) {
                        throw new RuntimeException("Detected non-loadstate 2 region with refreshing value being true.");
                    }
                    if (!isNewWorld || !shouldClear) continue;
                    region.deleteTexturesAndBuffers();
                }
            }
            if (isNewWorld) {
                if (shouldClear) {
                    this.mapSaveLoad.clearToCache();
                    this.currentMap.clear();
                    this.currentMapLists.clear();
                    this.detectedRegions.clear();
                    if (WorldMap.settings.debug) {
                        System.out.println("Map data cleared!");
                    }
                }
                this.lastWorld = this.currentWorldStringNoDim;
                this.lastWorldMainId = this.currentWorldStringNoDimMainId;
                this.currentWorldStringNoDim = newWorldStringNoDim;
                this.currentWorldStringNoDimMainId = this.newWorldStringNoDimMainId;
                this.currentWorldStringNoDimMultiworldId = this.newWorldStringNoDimMultiworldId;
                if (WorldMap.settings.debug) {
                    System.out.println("World changed!");
                }
            }
            this.currentDimension = this.newDimension;
            this.mapWriter.resetCaveStart();
            this.currentWorldString = this.currentWorldStringNoDim != null ? this.currentWorldStringNoDim.replace("%DIMENSION%", this.currentDimension) : null;
            this.footprints.clear();
            this.mapSaveLoad.clearToLoad();
            this.mapSaveLoad.clearLoadRequests();
            this.clearToRefresh();
            this.toProcess.clear();
            for (MapRegion region : this.getCurrentMapList(this.currentDimension)) {
                if (region.getLoadState() == 4 || region.getLoadState() == 0) continue;
                this.toProcess.add(region);
            }
            this.mapSaveLoad.updateCacheFolderList(this.mapSaveLoad.getSubFolder(this.currentWorldString));
            this.mapWriter.resetPosition();
            this.world = this.newWorld;
            this.player = this.newPlayer;
            if (WorldMap.settings.debug) {
                System.out.println("World/dimension changed to: " + this.currentWorldString);
            }
            if (shouldDetect = this.getDetectedRegions(this.currentDimension).isEmpty()) {
                this.mapSaveLoad.setRegionDetectionComplete(false);
            }
            this.popRenderPause(true, true);
            this.popWriterPause();
            if (shouldDetect) {
                this.mapSaveLoad.detectRegions();
                this.mapSaveLoad.setRegionDetectionComplete(true);
            }
        }
        this.waitingForWorldUpdate = false;
    }

    public void updateFootprints(World world, EntityPlayer player, int step) {
        if (WorldMap.settings.footsteps) {
            if (this.footprintsTimer > 0) {
                this.footprintsTimer -= step;
            } else {
                Double[] coords = new Double[]{player.field_70165_t, player.field_70161_v};
                this.footprints.add(coords);
                if (this.footprints.size() > 32) {
                    this.footprints.remove(0);
                }
                this.footprintsTimer = 20;
            }
        }
    }

    private void updateLighting(World world) {
        float sunBrightnessFactor = (float)Misc.round(world.getSunBrightnessFactor(1.0f), 1);
        if (sunBrightnessFactor > 1.0f) {
            sunBrightnessFactor = 1.0f;
        } else if (sunBrightnessFactor < 0.0f) {
            sunBrightnessFactor = 0.0f;
        }
        int currentLight = Misc.floatToLightLevel(sunBrightnessFactor);
        if (!WorldMap.settings.lighting) {
            currentLight = 0;
        }
        this.lightLevel = currentLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            if (!this.toRefresh.contains(region)) {
                this.toRefresh.add(0, region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToRefresh(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            this.toRefresh.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearToRefresh() {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            this.toRefresh.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRefresh(World world) throws RuntimeException {
        Object object = this.loadingSync;
        synchronized (object) {
            if (!this.waitingForWorldUpdate && !this.toRefresh.isEmpty()) {
                MapRegion region = this.toRefresh.get(0);
                if (region.isRefreshing()) {
                    boolean regionLoaded;
                    MapRegion mapRegion = region;
                    synchronized (mapRegion) {
                        boolean bl = regionLoaded = region.getLoadState() == 2;
                        if (regionLoaded) {
                            if (region.hasVersion() && region.getVersion() != WorldMap.globalVersion || !region.hasVersion() && region.getInitialVersion() != WorldMap.globalVersion) {
                                region.setShouldCache(true, "refresh handle");
                            }
                            region.setVersion(WorldMap.globalVersion);
                        }
                    }
                    if (regionLoaded) {
                        for (int i = 0; i < 8; ++i) {
                            for (int j = 0; j < 8; ++j) {
                                MapTileChunk chunk = region.getChunk(i, j);
                                if (chunk == null || chunk.getLoadState() != 2) continue;
                                if (chunk.getLoadState() != 2) {
                                    throw new RuntimeException("Trying to refresh a bad tile chunk: " + chunk.getX() + " " + chunk.getZ() + " from region " + region);
                                }
                                if (chunk.includeInSave()) {
                                    chunk.updateBuffers(world);
                                    continue;
                                }
                                region.setChunk(i, j, null);
                            }
                        }
                        MapRegion prevRegion = instance.getMapRegion(region.getRegionX(), region.getRegionZ() - 1, false);
                        if (prevRegion != null) {
                            prevRegion.setWaitingForRegionBelow(false);
                        }
                        if (WorldMap.settings.debug) {
                            System.out.println("Region refreshed: " + region + " " + region.getRegionX() + "_" + region.getRegionZ() + " " + this.mapWriter.getUpdateCounter());
                        }
                    }
                } else {
                    throw new RuntimeException(String.format("Trying to refresh region %s, which is not marked as being refreshed!", region));
                }
                region.setRefreshing(false);
                this.removeToRefresh(region);
            }
        }
    }

    public boolean regionExists(int x, int z) {
        Hashtable<Integer, RegionDetection> column = this.getDetectedRegions(this.currentDimension).get(x);
        return column != null && column.containsKey(z);
    }

    public void addRegionDetection(RegionDetection regionDetection) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = this.getDetectedRegions(this.currentDimension);
        Hashtable<Integer, RegionDetection> column = current.get(regionDetection.getRegionX());
        if (column == null) {
            column = new Hashtable();
            current.put(regionDetection.getRegionX(), column);
        }
        column.put(regionDetection.getRegionZ(), regionDetection);
    }

    public RegionDetection getRegionDetection(int x, int z) {
        Hashtable<Integer, RegionDetection> column = this.getDetectedRegions(this.currentDimension).get(x);
        if (column != null) {
            return column.get(z);
        }
        return null;
    }

    private void removeRegionDetection(int x, int z) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = this.getDetectedRegions(this.currentDimension);
        Hashtable<Integer, RegionDetection> column = current.get(x);
        if (column != null) {
            column.remove(z);
        }
        if (column.isEmpty()) {
            current.remove(x);
        }
    }

    public Hashtable<Integer, Hashtable<Integer, RegionDetection>> getDetectedRegions(String dim) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = this.detectedRegions.get(dim);
        if (current == null) {
            current = new Hashtable();
            this.detectedRegions.put(dim, current);
        }
        return current;
    }

    public List<MapRegion> getCurrentMapList(String dim) {
        List<MapRegion> current = this.currentMapLists.get(dim);
        if (current == null) {
            current = new ArrayList<MapRegion>();
            this.currentMapLists.put(dim, current);
        }
        return current;
    }

    public Hashtable<Integer, Hashtable<Integer, MapRegion>> getCurrentMap(String dim) {
        Hashtable<Integer, Hashtable<Integer, MapRegion>> current = this.currentMap.get(dim);
        if (current == null) {
            current = new Hashtable();
            this.currentMap.put(dim, current);
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapRegion(MapRegion region) {
        Hashtable<String, Hashtable<Integer, Hashtable<Integer, MapRegion>>> hashtable = this.currentMap;
        synchronized (hashtable) {
            Hashtable<Integer, MapRegion> mapColumn = this.getCurrentMap(region.getDim()).get(region.getRegionX());
            if (mapColumn == null) {
                return;
            }
            mapColumn.remove(region.getRegionZ());
            this.getCurrentMapList(region.getDim()).remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRegion getMapRegion(int regX, int regZ, boolean create) {
        Hashtable<String, Hashtable<Integer, Hashtable<Integer, MapRegion>>> hashtable = this.currentMap;
        synchronized (hashtable) {
            MapRegion region;
            Hashtable<Integer, MapRegion> mapColumn = this.getCurrentMap(this.currentDimension).get(regX);
            if (mapColumn == null) {
                if (create) {
                    mapColumn = new Hashtable();
                    this.getCurrentMap(this.currentDimension).put(regX, mapColumn);
                } else {
                    return null;
                }
            }
            if ((region = mapColumn.get(regZ)) == null) {
                if (create) {
                    region = new MapRegion(this.currentWorldString, this.currentDimension, regX, regZ);
                    RegionDetection regionDetection = this.getRegionDetection(regX, regZ);
                    if (regionDetection != null) {
                        regionDetection.transferInfoTo(region);
                        this.removeRegionDetection(regX, regZ);
                    }
                    this.getCurrentMapList(this.currentDimension).add(region);
                    mapColumn.put(regZ, region);
                } else {
                    return null;
                }
            }
            return region;
        }
    }

    public MapTileChunk getMapChunk(int chunkX, int chunkZ) {
        int regionX = chunkX >> 3;
        int regionZ = chunkZ >> 3;
        MapRegion region = this.getMapRegion(regionX, regionZ, false);
        if (region == null) {
            return null;
        }
        int localChunkX = chunkX & 7;
        int localChunkZ = chunkZ & 7;
        return region.getChunk(localChunkX, localChunkZ);
    }

    public MapTile getMapTile(int x, int z) {
        MapTileChunk tileChunk = this.getMapChunk(x >> 2, z >> 2);
        if (tileChunk == null) {
            return null;
        }
        int tileX = x & 3;
        int tileZ = z & 3;
        return tileChunk.getTile(tileX, tileZ);
    }

    public void updateWorldSpawn(BlockPos newSpawn) {
        this.currentSpawn = newSpawn;
        this.spawnToRestore = null;
        this.terrainDownloadEnded = -1L;
        if (WorldMap.settings.debug) {
            System.out.println("WORLD UPDATED TO SPAWN " + newSpawn);
        }
        try {
            this.changeWorld((World)Minecraft.func_71410_x().field_71441_e, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
        catch (Exception e) {
            System.out.println("World map failed to set the correct world spawn...");
            e.printStackTrace();
        }
    }

    public void onPlayerDied() {
        this.playerDeathTime = System.currentTimeMillis();
    }

    public void onWorldUnload() {
        if (WorldMap.settings.debug) {
            System.out.println("Changing worlds, pausing the world map...");
        }
        if (this.spawnToRestore == null) {
            this.spawnToRestore = this.currentSpawn;
        }
        this.terrainDownloadEnded = -1L;
        this.changeWorld(null, null);
    }

    public void onGuiClosed() {
        if (this.spawnToRestore != null && this.terrainDownloadEnded == -1L) {
            if (Minecraft.func_71410_x().func_147104_D() != null) {
                this.terrainDownloadEnded = System.currentTimeMillis();
            } else {
                if (WorldMap.settings.debug) {
                    System.out.println("SINGLEPLAYER SPAWN RESTORE");
                }
                this.updateWorldSpawn(this.spawnToRestore);
            }
        }
    }

    public void onClientTickStart() throws RuntimeException {
        this.checkForCrashes();
        if (this.spawnToRestore != null && this.terrainDownloadEnded != -1L && System.currentTimeMillis() - this.terrainDownloadEnded >= 3000L) {
            if (WorldMap.settings.debug) {
                System.out.println("SPAWN SET TIME OUT");
            }
            this.updateWorldSpawn(this.spawnToRestore);
        }
    }

    public void checkForCrashes() throws RuntimeException {
        if (this.crashedBy != null) {
            throw new RuntimeException("Xaero's World Map has crashed! Please contact the author at planetminecraft.com/member/xaero96 or minecraftforum.net/members/xaero96", this.crashedBy);
        }
    }

    private void updateRenderStartTime() {
        if (this.renderStartTime == -1L) {
            this.renderStartTime = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWriterPause() {
        Object object = this.writerThreadPauseSync;
        synchronized (object) {
            ++this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popWriterPause() {
        Object object = this.writerThreadPauseSync;
        synchronized (object) {
            --this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRenderPause(boolean rendering, boolean uploading) {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            if (rendering) {
                ++this.pauseRendering;
            }
            if (uploading) {
                ++this.pauseUploading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popRenderPause(boolean rendering, boolean uploading) {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            if (rendering) {
                --this.pauseRendering;
            }
            if (uploading) {
                --this.pauseUploading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushProcessorPause() {
        Object object = this.processorThreadPauseSync;
        synchronized (object) {
            ++this.pauseProcessing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popProcessorPause() {
        Object object = this.processorThreadPauseSync;
        synchronized (object) {
            --this.pauseProcessing;
        }
    }

    public boolean isWritingPaused() {
        return this.pauseWriting > 0;
    }

    public boolean isRenderingPaused() {
        return this.pauseRendering > 0;
    }

    public boolean isUploadingPaused() {
        return this.pauseUploading > 0;
    }

    public boolean isProcessingPaused() {
        return this.pauseProcessing > 0;
    }

    public String getCurrentDimension() {
        return this.currentDimension;
    }

    public Hashtable<String, Hashtable<Integer, Hashtable<Integer, MapRegion>>> getFullMap() {
        return this.currentMap;
    }

    public ArrayList<MapRegion> getToProcess() {
        return this.toProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToProcess(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toProcess;
        synchronized (arrayList) {
            this.toProcess.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToProcess(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toProcess;
        synchronized (arrayList) {
            this.toProcess.remove(region);
        }
    }

    public MapSaveLoad getMapSaveLoad() {
        return this.mapSaveLoad;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public World getWorld() {
        return this.world;
    }

    public Exception getCrashedBy() {
        return this.crashedBy;
    }

    public void setCrashedBy(Exception crashedBy) {
        this.crashedBy = crashedBy;
    }

    public String getCurrentWorldString() {
        return this.currentWorldString;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public MapWriter getMapWriter() {
        return this.mapWriter;
    }

    public void addTask(Runnable task) {
        this.tasks.add(task);
    }

    public MapLimiter getMapLimiter() {
        return this.mapLimiter;
    }

    public ArrayList<Double[]> getFootprints() {
        return this.footprints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTextureDeletion(int texture) {
        ArrayList<Integer> arrayList = this.texturesToDelete;
        synchronized (arrayList) {
            this.texturesToDelete.add(texture);
        }
    }

    public ByteBufferDeallocator getBufferDeallocator() {
        return this.bufferDeallocator;
    }

    public MapTilePool getTilePool() {
        return this.tilePool;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public int getGlobalVersion() {
        return WorldMap.globalVersion;
    }

    public void setGlobalVersion(int globalVersion) {
        WorldMap.globalVersion = globalVersion;
    }

    public void incrementGlobalVersion() {
        instance.addTask(new Runnable(){

            @Override
            public void run() {
                instance.setGlobalVersion(instance.getGlobalVersion() + 1);
                instance.getMapSaveLoad().updateCacheFolderList(instance.getMapSaveLoad().getSubFolder(instance.getCurrentWorldString()));
                if (WorldMap.settings.debug) {
                    System.out.println("Version incremented to " + instance.getGlobalVersion());
                }
                try {
                    WorldMap.settings.saveSettings();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public long getRenderStartTime() {
        return this.renderStartTime;
    }

    public void resetRenderStartTime() {
        this.renderStartTime = -1L;
    }

    public Queue<FutureTask<?>> getMinecraftScheduledTasks() {
        Queue result;
        this.scheduledTasksField.setAccessible(true);
        try {
            result = (Queue)this.scheduledTasksField.get(Minecraft.func_71410_x());
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        catch (IllegalAccessException e) {
            result = null;
        }
        this.scheduledTasksField.setAccessible(false);
        return result;
    }

    public Callable<Object> getRenderStartTimeUpdater() {
        return this.renderStartTimeUpdater;
    }

    public ArrayList<Integer> getBuffersToDelete() {
        return this.buffersToDelete;
    }

    public boolean isWaitingForWorldUpdate() {
        return this.waitingForWorldUpdate;
    }

    public void setWaitingForWorldUpdate(boolean waitingForWorldUpdate) {
        this.waitingForWorldUpdate = waitingForWorldUpdate;
    }
}

