/*
 * Decompiled with CFR 0.152.
 */
package com.camellias.resizer.network.packets;

import com.camellias.resizer.Main;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketOnResize
implements IMessage {
    public int entityID;
    private boolean shouldSpawnParticles;

    public PacketOnResize() {
    }

    public PacketOnResize(EntityLivingBase entity, boolean shouldSpawnParticles) {
        this.entityID = entity.func_145782_y();
        this.shouldSpawnParticles = shouldSpawnParticles;
    }

    public boolean shouldSpawnParticles() {
        return this.shouldSpawnParticles;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.shouldSpawnParticles);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.shouldSpawnParticles = buf.readBoolean();
    }

    @Nullable
    protected EntityLivingBase removePotionEffect(MessageContext ctx, boolean removeGrowth, boolean removeShrinking) {
        EntityLivingBase entity = Main.proxy.getEntityLivingBase(ctx, this.entityID);
        if (entity != null) {
            if (removeGrowth) {
                entity.func_184589_d(Main.GROWTH);
            }
            if (removeShrinking) {
                entity.func_184589_d(Main.SHRINKING);
            }
            if (this.shouldSpawnParticles) {
                Random rand = new Random();
                double xSpeed = rand.nextGaussian() * 0.02;
                double ySpeed = rand.nextGaussian() * 0.02;
                double zSpeed = rand.nextGaussian() * 0.02;
                for (int k = 0; k < 30; ++k) {
                    entity.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, entity.field_70165_t + (double)(rand.nextFloat() * entity.field_70130_N) * 2.0 - (double)entity.field_70130_N, entity.field_70163_u + (double)(rand.nextFloat() * entity.field_70131_O), entity.field_70161_v + (double)(rand.nextFloat() * entity.field_70130_N) * 2.0 - (double)entity.field_70130_N, xSpeed, ySpeed, zSpeed, new int[0]);
                }
            }
            return entity;
        }
        return null;
    }
}

