/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.FrozenEntityProperties;
import com.github.alexthe666.iceandfire.entity.IDragonProjectile;
import com.github.alexthe666.iceandfire.entity.IceExplosion;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityDragonIceProjectile
extends EntityFireball
implements IDragonProjectile {
    public EntityDragonIceProjectile(World worldIn) {
        super(worldIn);
    }

    public EntityDragonIceProjectile(World worldIn, double posX, double posY, double posZ, double accelX, double accelY, double accelZ) {
        super(worldIn, posX, posY, posZ, accelX, accelY, accelZ);
    }

    public EntityDragonIceProjectile(World worldIn, EntityDragonBase shooter, double accelX, double accelY, double accelZ) {
        super(worldIn, (EntityLivingBase)shooter, accelX, accelY, accelZ);
        this.func_70105_a(0.5f, 0.5f);
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.field_70232_b = accelX / d0 * (0.1 * (double)(shooter.isFlying() ? 4 * shooter.getDragonStage() : 1));
        this.field_70233_c = accelY / d0 * (0.1 * (double)(shooter.isFlying() ? 4 * shooter.getDragonStage() : 1));
        this.field_70230_d = accelZ / d0 * (0.1 * (double)(shooter.isFlying() ? 4 * shooter.getDragonStage() : 1));
    }

    public void setSizes(float width, float height) {
        this.func_70105_a(width, height);
    }

    protected boolean func_184564_k() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        for (int i = 0; i < 6; ++i) {
            IceAndFire.PROXY.spawnParticle("dragonice", this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        }
        if (this.field_70173_aa > 160) {
            this.func_70106_y();
        }
        if (this.field_70122_E) {
            // empty if block
        }
    }

    protected void func_70227_a(RayTraceResult movingObject) {
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        if (!this.field_70170_p.field_72995_K) {
            if (movingObject.field_72308_g != null && movingObject.field_72308_g instanceof IDragonProjectile) {
                return;
            }
            if (movingObject.field_72308_g != null && this.field_70235_a != null && this.field_70235_a instanceof EntityDragonBase && ((EntityDragonBase)this.field_70235_a).func_70909_n() && movingObject.field_72308_g instanceof EntityPlayer && ((EntityDragonBase)this.field_70235_a).func_152114_e((EntityLivingBase)((EntityPlayer)movingObject.field_72308_g))) {
                return;
            }
            if (movingObject.field_72308_g != null && !(movingObject.field_72308_g instanceof IDragonProjectile) && this.field_70235_a != null && this.field_70235_a instanceof EntityDragonBase && movingObject.field_72308_g != this.field_70235_a || movingObject.field_72308_g == null) {
                if (this.field_70235_a != null && (movingObject.field_72308_g == this.field_70235_a || this.field_70235_a instanceof EntityDragonBase & movingObject.field_72308_g instanceof EntityTameable && ((EntityDragonBase)this.field_70235_a).func_70902_q() == ((EntityTameable)movingObject.field_72308_g).func_70902_q())) {
                    return;
                }
                if (this.field_70235_a != null && this.field_70235_a instanceof EntityDragonBase && IceAndFire.CONFIG.dragonGriefing != 2) {
                    IceExplosion explosion = new IceExplosion(this.field_70170_p, (Entity)this.field_70235_a, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)((EntityDragonBase)this.field_70235_a).getDragonStage() * 2.5f, flag);
                    explosion.func_77278_a();
                    explosion.func_77279_a(true);
                }
                this.func_70106_y();
            }
            if (movingObject.field_72308_g != null && !(movingObject.field_72308_g instanceof IDragonProjectile) && !movingObject.field_72308_g.func_70028_i((Entity)this.field_70235_a)) {
                FrozenEntityProperties frozenProps;
                if (this.field_70235_a != null && (movingObject.field_72308_g.func_70028_i((Entity)this.field_70235_a) || this.field_70235_a instanceof EntityDragonBase & movingObject.field_72308_g instanceof EntityTameable && ((EntityDragonBase)this.field_70235_a).func_70902_q() == ((EntityTameable)movingObject.field_72308_g).func_70902_q())) {
                    return;
                }
                if (this.field_70235_a != null && this.field_70235_a instanceof EntityDragonBase && movingObject.field_72308_g instanceof EntityLivingBase && ((EntityLivingBase)movingObject.field_72308_g).func_110143_aJ() == 0.0f) {
                    ((EntityDragonBase)this.field_70235_a).attackDecision = true;
                }
                this.func_174815_a(this.field_70235_a, movingObject.field_72308_g);
                movingObject.field_72308_g.func_70097_a(IceAndFire.dragonIce, 1.0f);
                if (movingObject.field_72308_g instanceof EntityLivingBase && (frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(movingObject.field_72308_g, FrozenEntityProperties.class)) != null) {
                    frozenProps.setFrozenFor(200);
                }
            }
        }
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public void setAim(Entity fireball, Entity entity, float p_184547_2_, float p_184547_3_, float p_184547_4_, float p_184547_5_, float p_184547_6_) {
        float f = -MathHelper.func_76126_a((float)(p_184547_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_184547_2_ * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(p_184547_2_ * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(p_184547_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_184547_2_ * ((float)Math.PI / 180)));
        fireball.field_70159_w = entity.field_70159_w;
        fireball.field_70179_y = entity.field_70179_y;
        if (!entity.field_70122_E) {
            fireball.field_70181_x = entity.field_70181_x;
        }
        this.setThrowableHeading(fireball, f, f1, f2, p_184547_5_, p_184547_6_);
    }

    public void setThrowableHeading(Entity fireball, double x, double y, double z, float velocity, float inaccuracy) {
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        fireball.field_70159_w = x *= (double)velocity;
        fireball.field_70181_x = y *= (double)velocity;
        fireball.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        fireball.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        fireball.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        fireball.field_70126_B = fireball.field_70177_z;
        fireball.field_70127_C = fireball.field_70125_A;
    }

    public float func_70111_Y() {
        return 1.0f;
    }
}

