/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.render.item;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.util.VertexDataUtils;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class LatticeModelCreator {
    public static List<BakedQuad> generateLatticeModel(Set<TextureAtlasSprite> sprites) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        VertexFormat format = DefaultVertexFormats.field_176599_b;
        ColourRGBA colour = new ColourRGBA(-1);
        double scale = 0.0625;
        int i = 0;
        for (TextureAtlasSprite sprite : sprites) {
            double d3;
            double d2;
            double d1;
            int j;
            float minU = sprite.func_94209_e();
            float maxU = sprite.func_94212_f();
            float minV = sprite.func_94206_g();
            float maxV = sprite.func_94210_h();
            int iconWidth = sprite.func_94211_a();
            int iconHeight = sprite.func_94216_b();
            Vertex5 v1 = new Vertex5();
            Vertex5 v2 = new Vertex5();
            Vertex5 v3 = new Vertex5();
            Vertex5 v4 = new Vertex5();
            v1.set(0.0, 0.0, 0.0, (double)maxU, (double)maxV);
            v2.set(1.0, 0.0, 0.0, (double)minU, (double)maxV);
            v3.set(1.0, 1.0, 0.0, (double)minU, (double)minV);
            v4.set(0.0, 1.0, 0.0, (double)maxU, (double)minV);
            quads.add(LatticeModelCreator.buildQuad(format, sprite, EnumFacing.SOUTH, (Colour)colour, i, v1, v2, v3, v4));
            v1.set(0.0, 1.0, 0.0 - scale, (double)maxU, (double)minV);
            v2.set(1.0, 1.0, 0.0 - scale, (double)minU, (double)minV);
            v3.set(1.0, 0.0, 0.0 - scale, (double)minU, (double)maxV);
            v4.set(0.0, 0.0, 0.0 - scale, (double)maxU, (double)maxV);
            quads.add(LatticeModelCreator.buildQuad(format, sprite, EnumFacing.NORTH, (Colour)colour, i, v1, v2, v3, v4));
            double sU = 0.5 * (double)(maxU - minU) / (double)iconWidth;
            double sV = 0.5 * (double)(maxV - minV) / (double)iconWidth;
            for (j = 0; j < iconWidth; ++j) {
                d1 = (double)j / (double)iconWidth;
                d2 = (double)maxU + (double)(minU - maxU) * d1 - sU;
                v1.set(d1, 0.0, 0.0 - scale, d2, (double)maxV);
                v2.set(d1, 0.0, 0.0, d2, (double)maxV);
                v3.set(d1, 1.0, 0.0, d2, (double)minV);
                v4.set(d1, 1.0, 0.0 - scale, d2, (double)minV);
                quads.add(LatticeModelCreator.buildQuad(format, sprite, EnumFacing.WEST, (Colour)colour, i, v1, v2, v3, v4));
            }
            for (j = 0; j < iconWidth; ++j) {
                d1 = (double)j / (double)iconWidth;
                d2 = (double)maxU + (double)(minU - maxU) * d1 - sU;
                d3 = d1 + (double)(1.0f / (float)iconWidth);
                v1.set(d3, 1.0, 0.0 - scale, d2, (double)minV);
                v2.set(d3, 1.0, 0.0, d2, (double)minV);
                v3.set(d3, 0.0, 0.0, d2, (double)maxV);
                v4.set(d3, 0.0, 0.0 - scale, d2, (double)maxV);
                quads.add(LatticeModelCreator.buildQuad(format, sprite, EnumFacing.EAST, (Colour)colour, i, v1, v2, v3, v4));
            }
            for (j = 0; j < iconHeight; ++j) {
                d1 = (float)j / (float)iconHeight;
                d2 = (double)maxV + (double)(minV - maxV) * d1 - sV;
                d3 = d1 + (double)(1.0f / (float)iconHeight);
                v1.set(0.0, d3, 0.0, (double)maxU, d2);
                v2.set(1.0, d3, 0.0, (double)minU, d2);
                v3.set(1.0, d3, 0.0 - scale, (double)minU, d2);
                v4.set(0.0, d3, 0.0 - scale, (double)maxU, d2);
                quads.add(LatticeModelCreator.buildQuad(format, sprite, EnumFacing.UP, (Colour)colour, i, v1, v2, v3, v4));
            }
            for (j = 0; j < iconHeight; ++j) {
                d1 = (float)j / (float)iconHeight;
                d2 = (double)maxV + (double)(minV - maxV) * d1 - sV;
                v1.set(1.0, d1, 0.0, (double)minU, d2);
                v2.set(0.0, d1, 0.0, (double)maxU, d2);
                v3.set(0.0, d1, 0.0 - scale, (double)maxU, d2);
                v4.set(1.0, d1, 0.0 - scale, (double)minU, d2);
                quads.add(LatticeModelCreator.buildQuad(format, sprite, EnumFacing.DOWN, (Colour)colour, i, v1, v2, v3, v4));
            }
            ++i;
        }
        return quads;
    }

    private static BakedQuad buildQuad(VertexFormat format, TextureAtlasSprite sprite, EnumFacing face, Colour colour, int tint, Vertex5 v1, Vertex5 v2, Vertex5 v3, Vertex5 v4) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(face);
        builder.setTexture(sprite);
        LatticeModelCreator.putVertex(builder, format, face, v1, colour);
        LatticeModelCreator.putVertex(builder, format, face, v2, colour);
        LatticeModelCreator.putVertex(builder, format, face, v3, colour);
        LatticeModelCreator.putVertex(builder, format, face, v4, colour);
        return VertexDataUtils.copyQuad((UnpackedBakedQuad)builder.build());
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, EnumFacing face, Vertex5 vert, Colour colour) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            VertexFormatElement element = format.func_177348_c(e);
            switch (element.func_177375_c()) {
                case POSITION: {
                    Vector3 vec = vert.vec;
                    builder.put(e, new float[]{(float)vec.x, (float)vec.y, (float)vec.z, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{face.func_82601_c(), face.func_96559_d(), face.func_82599_e(), 0.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{(float)(colour.r & 0xFF) / 255.0f, (float)(colour.g & 0xFF) / 255.0f, (float)(colour.b & 0xFF) / 255.0f, (float)(colour.a & 0xFF) / 255.0f});
                    continue block6;
                }
                case UV: {
                    UV uv = vert.uv;
                    builder.put(e, new float[]{(float)uv.u, (float)uv.v, 0.0f, 1.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }
}

