/*
 * Decompiled with CFR 0.152.
 */
package shadows.ench.altar;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import shadows.ench.altar.TilePrismaticAltar;

public class BlockPrismaticAltar
extends Block {
    static final double px = 0.0625;
    public static final AxisAlignedBB DISPLAY = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
    public static final List<AxisAlignedBB> BOXES = ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), (Object)new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.1875, 0.9375), (Object)new AxisAlignedBB(0.125, 0.25, 0.125, 0.25, 0.625, 0.25), (Object)new AxisAlignedBB(0.125, 0.25, 0.75, 0.25, 0.625, 0.875), (Object)new AxisAlignedBB(0.75, 0.25, 0.125, 0.875, 0.625, 0.25), (Object)new AxisAlignedBB(0.75, 0.25, 0.75, 0.875, 0.625, 0.875));
    public static final List<AxisAlignedBB> PILLARS = ImmutableList.of((Object)BOXES.get(2), (Object)BOXES.get(3), (Object)BOXES.get(4), (Object)BOXES.get(5));

    public BlockPrismaticAltar() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setRegistryName("apotheosis", "prismatic_altar");
        this.func_149663_c("apotheosis.prismatic_altar");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TilePrismaticAltar)) {
            return false;
        }
        TilePrismaticAltar altar = (TilePrismaticAltar)te;
        Vec3d eyes = player.func_174824_e(1.0f);
        Vec3d look = player.func_70676_i(1.0f);
        double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d block = eyes.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
        for (int i = 0; i < 4; ++i) {
            if (this.func_185503_a(pos, eyes, block, PILLARS.get(i)) == null) continue;
            return this.attemptSwap(altar, i, player, hand);
        }
        if ((double)hitX >= 0.34375 && (double)hitX <= 0.65625 || (double)hitZ >= 0.34375 && (double)hitZ <= 0.65625) {
            this.attemptSwap(altar, 4, player, hand);
        }
        return true;
    }

    protected boolean attemptSwap(TilePrismaticAltar altar, int slot, EntityPlayer player, EnumHand hand) {
        ItemStackHandler inv = altar.getInv();
        ItemStack inAltar = inv.getStackInSlot(slot);
        ItemStack inHand = player.func_184586_b(hand);
        if (slot == 4 && !inHand.func_190926_b()) {
            return true;
        }
        if (inAltar.func_190926_b() && (inHand.func_77948_v() || inHand.func_77973_b() == Items.field_151134_bR)) {
            ItemStack toAltar = inHand.func_77946_l();
            inHand.func_190918_g(1);
            toAltar.func_190920_e(1);
            inv.setStackInSlot(slot, toAltar);
            altar.markAndNotify();
        } else if (!inAltar.func_190926_b() && inHand.func_190926_b()) {
            player.func_184611_a(hand, inAltar.func_77946_l());
            inAltar.func_190920_e(0);
            altar.markAndNotify();
        }
        return true;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        for (AxisAlignedBB bb : BOXES) {
            BlockPrismaticAltar.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bb);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList<RayTraceResult> list = new ArrayList<RayTraceResult>();
        for (AxisAlignedBB bb : BOXES) {
            list.add(this.func_185503_a(pos, start, end, bb));
        }
        RayTraceResult result = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            result = raytraceresult;
            d1 = d0;
        }
        return result;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DISPLAY;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePrismaticAltar();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TilePrismaticAltar) {
            ItemStackHandler inv = ((TilePrismaticAltar)te).inv;
            for (int i = 0; i < inv.getSlots(); ++i) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
            }
        }
        super.func_180663_b(world, pos, state);
    }
}

