/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.crt;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import shadows.util.ArmorSet;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.apotheosis.BossArmor")
@ZenRegister
public class BossArmorTweaker {
    @ZenMethod
    public static void removeArmorSet(final int level) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArmorSet.LEVEL_TO_SETS.remove(level);
            }

            public String describe() {
                return String.format("Removed armor set for level %s.", level);
            }
        });
    }

    @ZenMethod
    public static void addArmorSet(final int level, final IItemStack mainhand, final IItemStack offhand, final IItemStack feet, final IItemStack legs, final IItemStack chest, final IItemStack head) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArmorSet set = new ArmorSet(level, CraftTweakerMC.getItemStacks((IItemStack[])new IItemStack[]{mainhand, offhand, feet, legs, chest, head}));
                ArmorSet.LEVEL_TO_SETS.put(level, set);
            }

            public String describe() {
                return String.format("Added armor set for level %s.", level);
            }
        });
    }

    @ZenMethod
    public static void addPossibleWeapons(final int level, final WeightedItemStack ... stacks) {
        if (ArmorSet.LEVEL_TO_SETS == null) {
            CraftTweakerAPI.logError((String)String.format("Attempted to add possible weapons for level %s, but there is no set at that level!", level));
            return;
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArmorSet set = ArmorSet.LEVEL_TO_SETS.get(level);
                set.setupList();
                for (WeightedItemStack s : stacks) {
                    set.getPossibleMainhands().add(new ArmorSet.WeightedRandomStack(CraftTweakerMC.getItemStack((IItemStack)s.getStack()), (int)(s.getPercent() * 100.0f)));
                }
            }

            public String describe() {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("Added potential mainhands to Armor set level %s.\n", level));
                for (WeightedItemStack s : stacks) {
                    sb.append(String.format("Item %s, Weight %s; ", s.getStack().toCommandString(), (int)(s.getPercent() * 100.0f)));
                }
                return sb.toString();
            }
        });
    }
}

