/*
 * Decompiled with CFR 0.152.
 */
package shadows;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.ApotheosisCore;
import shadows.deadly.DeadlyModule;
import shadows.ench.EnchModule;
import shadows.garden.GardenModule;
import shadows.placebo.util.RecipeHelper;
import shadows.potion.PotionModule;
import shadows.spawn.SpawnerModule;
import shadows.util.NBTIngredient;
import shadows.util.ParticleMessage;

@Mod(modid="apotheosis", name="Apotheosis", version="1.8.6", dependencies="required-after:placebo@[1.5.1,)", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class Apotheosis {
    public static final String MODID = "apotheosis";
    public static final String MODNAME = "Apotheosis";
    public static final String Version = "1.8.6";
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("apotheosis");
    public static File configDir;
    public static Configuration config;
    public static boolean enableSpawner;
    public static boolean enableGarden;
    public static boolean enableDeadly;
    public static boolean enableEnch;
    public static boolean enablePotion;
    public static boolean enchTooltips;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        configDir = new File(e.getModConfigurationDirectory(), MODID);
        config = new Configuration(new File(configDir, "apotheosis.cfg"));
        ApotheosisCore.enableEnch = enableEnch = config.getBoolean("Enable Enchantment Module", "general", true, "If the enchantment module is enabled.");
        if (enableEnch) {
            MinecraftForge.EVENT_BUS.register((Object)new EnchModule());
        }
        ApotheosisCore.enableSpawner = enableSpawner = config.getBoolean("Enable Spawner Module", "general", true, "If the spawner module is enabled.");
        if (enableSpawner) {
            MinecraftForge.EVENT_BUS.register((Object)new SpawnerModule());
        }
        if (enableGarden = config.getBoolean("Enable Garden Module", "general", true, "If the garden module is loaded.")) {
            MinecraftForge.EVENT_BUS.register((Object)new GardenModule());
        }
        ApotheosisCore.enableDeadly = enableDeadly = config.getBoolean("Enable Deadly Module", "general", true, "If the deadly module is loaded.");
        if (enableDeadly) {
            MinecraftForge.EVENT_BUS.register((Object)new DeadlyModule());
        }
        ApotheosisCore.enablePotion = enablePotion = config.getBoolean("Enable Potion Module", "general", true, "If the potion module is loaded.");
        if (enablePotion) {
            MinecraftForge.EVENT_BUS.register((Object)new PotionModule());
        }
        enchTooltips = config.getBoolean("Enchantment Tooltips", "client", true, "If apotheosis enchantments have tooltips on books.");
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.post((Event)new ApotheosisPreInit(e));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) throws IOException {
        MinecraftForge.EVENT_BUS.post((Event)new ApotheosisInit(e));
        NETWORK.registerMessage(ParticleMessage.Handler.class, ParticleMessage.class, 0, Side.CLIENT);
    }

    @SubscribeEvent
    public void recipes(RegistryEvent.Register<IRecipe> e) {
        RecipeHelper helper = new RecipeHelper(MODID, MODNAME, new ArrayList());
        MinecraftForge.EVENT_BUS.post((Event)new ApotheosisRecipeEvent(helper));
        helper.register(e.getRegistry());
    }

    public static void registerOverrideBlock(IForgeRegistry<Block> reg, Block b, final String modid) {
        reg.register((IForgeRegistryEntry)b);
        ForgeRegistries.ITEMS.register(new ItemBlock(b){

            public String getCreatorModId(ItemStack itemStack) {
                return modid;
            }
        }.setRegistryName(b.getRegistryName()));
    }

    public static Ingredient potionIngredient(PotionType type) {
        return new NBTIngredient(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)type));
    }

    static {
        enableSpawner = true;
        enableGarden = true;
        enableDeadly = true;
        enableEnch = true;
        enablePotion = true;
        enchTooltips = true;
    }

    public static class ApotheosisRecipeEvent
    extends Event {
        public RecipeHelper helper;

        private ApotheosisRecipeEvent(RecipeHelper helper) {
            this.helper = helper;
        }
    }

    public static class ApotheosisInit
    extends Event {
        public FMLInitializationEvent ev;

        private ApotheosisInit(FMLInitializationEvent ev) {
            this.ev = ev;
        }
    }

    public static class ApotheosisPreInit
    extends Event {
        public FMLPreInitializationEvent ev;

        private ApotheosisPreInit(FMLPreInitializationEvent ev) {
            this.ev = ev;
        }
    }
}

