/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.handlers.java.util.HandleMap;
import info.loenwind.autosave.util.BitUtil;
import info.loenwind.autosave.util.Log;
import info.loenwind.autosave.util.NBTAction;
import info.loenwind.autosave.util.NonnullType;
import info.loenwind.autosave.util.NullHelper;
import info.loenwind.autosave.util.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class HandleEnum2EnumMap<T extends Enum<T>>
extends HandleMap<EnumMap<T, Enum>> {
    private final Class<T> keyClass;
    private final T[] keys;
    private final Enum[] vals;
    private final int valspace;

    public HandleEnum2EnumMap() throws NoHandlerFoundException {
        super(EnumMap.class);
        this.keyClass = Enum.class;
        this.keys = new Enum[0];
        this.vals = new Enum[0];
        this.valspace = 0;
    }

    protected HandleEnum2EnumMap(Registry registry, Class<? extends Enum> keyClass, Class<? extends Enum> valClass) throws NoHandlerFoundException {
        super(EnumMap.class, registry, keyClass, valClass);
        this.keyClass = keyClass;
        this.keys = this.getEnumConstants(keyClass);
        this.vals = this.getEnumConstants(valClass);
        this.valspace = this.getValspace(this.vals.length);
        if (this.keys.length * this.valspace > 64) {
            throw new IllegalArgumentException("Enums " + keyClass + " and " + valClass + " cannot be used, as they have too many combinations.");
        }
    }

    private <E> E[] getEnumConstants(Class<E> clazz) {
        return NullHelper.notnullJ(clazz.getEnumConstants(), "Class#getEnumConstants");
    }

    private int getValspace(int valCount) {
        return Integer.numberOfTrailingZeros(Integer.highestOneBit(valCount + 1)) + 1;
    }

    @Override
    protected EnumMap<T, Enum> createMap() {
        return new EnumMap(this.keyClass);
    }

    @Override
    public boolean canHandle(Type type) {
        if (super.canHandle(type) && type instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            @NonnullType Class[] paramClasses = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                paramClasses[i] = TypeUtil.toClass(NullHelper.notnullJ(types[i], "ParameterizedType#getActualTypeArguments[i]"));
            }
            if (paramClasses.length == 2 && paramClasses[0].isEnum() && paramClasses[1].isEnum()) {
                int vals;
                int valspace;
                int keys = this.getEnumConstants(paramClasses[0]).length;
                return keys * (valspace = this.getValspace(vals = this.getEnumConstants(paramClasses[1]).length)) <= 64;
            }
        }
        return false;
    }

    @Override
    protected IHandler<? extends EnumMap<T, Enum>> create(Registry registry, Type ... types) throws NoHandlerFoundException {
        return new HandleEnum2EnumMap<T>(registry, TypeUtil.toClass(types[0]), TypeUtil.toClass(types[1]));
    }

    @Override
    public boolean store(Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, Type type, String name, EnumMap<T, Enum> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        long value = 0L;
        for (T key : this.keys) {
            long subvalue = 0L;
            if (object.containsKey(key)) {
                subvalue = object.get(key).ordinal() + 1;
            }
            value |= subvalue << ((Enum)key).ordinal() * this.valspace;
        }
        nbt.func_74783_a(name, new int[]{this.valspace, BitUtil.getLongMSB(value), BitUtil.getLongLSB(value)});
        return true;
    }

    @Override
    @Nullable
    public EnumMap read(Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, Type type, String name, @Nullable EnumMap<T, Enum> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            int[] raw;
            if (object == null) {
                object = this.createMap();
            }
            if ((raw = nbt.func_74759_k(name)).length == 0) {
                long value = nbt.func_74763_f(name);
                for (T key : this.keys) {
                    long subvalue = value >>> ((Enum)key).ordinal() * 8 & 0xFFL;
                    if (subvalue > 0L && subvalue < (long)this.vals.length) {
                        ((EnumMap)object).put(key, this.vals[(int)subvalue]);
                        continue;
                    }
                    ((EnumMap)object).remove(key);
                }
                return object;
            }
            int space = raw[0];
            int mask = (1 << space) - 1;
            long value = BitUtil.longFromInts(raw[1], raw[2]);
            for (T key : this.keys) {
                long subvalue = value >>> ((Enum)key).ordinal() * space & (long)mask;
                if (subvalue > 0L && subvalue <= (long)this.vals.length) {
                    ((EnumMap)object).put(key, this.vals[(int)subvalue - 1]);
                    continue;
                }
                if (subvalue == 0L) {
                    ((EnumMap)object).remove(key);
                    continue;
                }
                Log.error("Found invalid map value when parsing enum2enum map! Data: %s   Type: %s", nbt, type);
                Thread.dumpStack();
            }
        }
        return object;
    }
}

