/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.TRLUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class NetHandlerPlayServerPatch
extends Patch {
    public static final String TIMEOUTS_CONFIG = NetHandlerPlayServerPatch.getName(RPConfig.Timeouts.class);
    public static final String SPEED_LIMITS_CONFIG = NetHandlerPlayServerPatch.getName(RPConfig.SpeedLimits.class);
    public static final String SEND_PACKET = NetHandlerPlayServerPatch.getName("sendPacket", "func_147359_a");

    @Override
    public boolean apply(ClassNode node) {
        NetHandlerPlayServerPatch.patchUpdate(NetHandlerPlayServerPatch.findMethod(node, "update", "func_73660_a"));
        if (!RandomPatches.SPONGEFORGE_INSTALLED) {
            NetHandlerPlayServerPatch.patchProcessPlayer(NetHandlerPlayServerPatch.findMethod(node, "processPlayer", "func_147347_a"));
            NetHandlerPlayServerPatch.patchProcessVehicleMove(NetHandlerPlayServerPatch.findMethod(node, "processVehicleMove", "func_184338_a"));
        }
        return true;
    }

    private static void patchUpdate(MethodNode method) {
        LdcInsnNode keepAliveInterval = null;
        JumpInsnNode ifeq = null;
        MethodInsnNode sendPacket = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            if (keepAliveInterval == null) {
                if (instruction.getType() != 9) continue;
                keepAliveInterval = (LdcInsnNode)instruction;
                if (TRLUtils.MC_VERSION_NUMBER > 11) {
                    if (Long.valueOf(15000L).equals(keepAliveInterval.cst)) continue;
                    keepAliveInterval = null;
                    continue;
                }
                if (Long.valueOf(40L).equals(keepAliveInterval.cst)) continue;
                keepAliveInterval = null;
                continue;
            }
            if (ifeq == null) {
                if (instruction.getOpcode() != 153 || instruction.getPrevious().getOpcode() != 180) continue;
                ifeq = (JumpInsnNode)instruction;
                continue;
            }
            if (instruction.getOpcode() != 182) continue;
            sendPacket = (MethodInsnNode)instruction;
            if (SEND_PACKET.equals(sendPacket.name)) break;
            sendPacket = null;
        }
        FieldInsnNode getKeepAliveInterval = new FieldInsnNode(178, TIMEOUTS_CONFIG, TRLUtils.MC_VERSION_NUMBER > 11 ? "keepAlivePacketIntervalMillis" : "keepAlivePacketIntervalLong", "J");
        method.instructions.insert((AbstractInsnNode)keepAliveInterval, (AbstractInsnNode)getKeepAliveInterval);
        method.instructions.remove((AbstractInsnNode)keepAliveInterval);
        if (TRLUtils.MC_VERSION_NUMBER < 12) {
            return;
        }
        LabelNode label = new LabelNode();
        VarInsnNode loadCurrentTime = new VarInsnNode(22, 1);
        VarInsnNode loadThis = new VarInsnNode(25, 0);
        FieldInsnNode getLastPingTime = new FieldInsnNode(180, "net/minecraft/network/NetHandlerPlayServer", "field_194402_f", "J");
        InsnNode subtract = new InsnNode(101);
        FieldInsnNode getReadTimeoutMillis = new FieldInsnNode(178, TIMEOUTS_CONFIG, "readTimeoutMillis", "J");
        InsnNode compare = new InsnNode(148);
        JumpInsnNode jumpIfNotLarger = new JumpInsnNode(155, label);
        method.instructions.insert((AbstractInsnNode)ifeq, (AbstractInsnNode)loadCurrentTime);
        method.instructions.insert((AbstractInsnNode)loadCurrentTime, (AbstractInsnNode)loadThis);
        method.instructions.insert((AbstractInsnNode)loadThis, (AbstractInsnNode)getLastPingTime);
        method.instructions.insert((AbstractInsnNode)getLastPingTime, (AbstractInsnNode)subtract);
        method.instructions.insert((AbstractInsnNode)subtract, (AbstractInsnNode)getReadTimeoutMillis);
        method.instructions.insert((AbstractInsnNode)getReadTimeoutMillis, (AbstractInsnNode)compare);
        method.instructions.insert((AbstractInsnNode)compare, (AbstractInsnNode)jumpIfNotLarger);
        method.instructions.insert((AbstractInsnNode)sendPacket, (AbstractInsnNode)label);
    }

    private static void patchProcessPlayer(MethodNode method) {
        LdcInsnNode elytra = null;
        LdcInsnNode normal = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            if (instruction.getOpcode() != 18) continue;
            LdcInsnNode ldc = (LdcInsnNode)instruction;
            if (elytra == null && Float.valueOf(300.0f).equals(ldc.cst)) {
                elytra = ldc;
                continue;
            }
            if (!Float.valueOf(100.0f).equals(ldc.cst)) continue;
            normal = ldc;
            break;
        }
        FieldInsnNode getElytraMaxSpeed = new FieldInsnNode(178, SPEED_LIMITS_CONFIG, "maxPlayerElytraSpeed", "F");
        FieldInsnNode getNormalMaxSpeed = new FieldInsnNode(178, SPEED_LIMITS_CONFIG, "maxPlayerSpeed", "F");
        method.instructions.insert(elytra, (AbstractInsnNode)getElytraMaxSpeed);
        method.instructions.remove((AbstractInsnNode)elytra);
        method.instructions.insert((AbstractInsnNode)normal, (AbstractInsnNode)getNormalMaxSpeed);
        method.instructions.remove((AbstractInsnNode)normal);
    }

    private static void patchProcessVehicleMove(MethodNode method) {
        LdcInsnNode speed = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            if (instruction.getOpcode() != 18) continue;
            LdcInsnNode ldc = (LdcInsnNode)instruction;
            if (!Double.valueOf(100.0).equals(ldc.cst)) continue;
            speed = ldc;
            break;
        }
        FieldInsnNode getVehicleMaxSpeed = new FieldInsnNode(178, SPEED_LIMITS_CONFIG, "maxPlayerVehicleSpeed", "D");
        method.instructions.insert(speed, (AbstractInsnNode)getVehicleMaxSpeed);
        method.instructions.remove(speed);
    }
}

