/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.builder;

import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeBuilderException;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementBuilder;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.builder.ZenRecipeBuilder;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.builder.ZenRecipeBuilderNoOp;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.builder.copy.IZenRecipeBuilderCopyStrategy;
import com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers.CTLogHelper;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import java.util.HashMap;
import java.util.Map;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.artisanworktables.builder.RecipeBuilder")
public interface IZenRecipeBuilder {
    public static final Map<String, IZenRecipeBuilder> BUILDER_MAP = new HashMap<String, IZenRecipeBuilder>();

    @ZenMethod
    public static IZenRecipeBuilder get(String table) {
        if (!ArtisanAPI.isWorktableNameValid(table = table.toLowerCase())) {
            CTLogHelper.logErrorFromZenMethod((String)("Unknown table type: " + table));
            CTLogHelper.logInfo((String)("Valid table types are: " + String.join((CharSequence)",", ArtisanAPI.getWorktableNames())));
            return ZenRecipeBuilderNoOp.INSTANCE;
        }
        IZenRecipeBuilder builder = BUILDER_MAP.get(table);
        if (builder == null) {
            try {
                builder = new ZenRecipeBuilder(table);
                BUILDER_MAP.put(table, builder);
            }
            catch (RecipeBuilderException e) {
                CTLogHelper.logErrorFromZenMethod((String)e.getMessage());
                return ZenRecipeBuilderNoOp.INSTANCE;
            }
        }
        return builder;
    }

    @ZenMethod
    public IZenRecipeBuilder setName(String var1);

    @ZenMethod
    public IZenRecipeBuilder setShaped(IIngredient[][] var1);

    @ZenMethod
    public IZenRecipeBuilder setShapeless(IIngredient[] var1);

    @ZenMethod
    public IZenRecipeBuilder setFluid(ILiquidStack var1);

    @ZenMethod
    public IZenRecipeBuilder setSecondaryIngredients(IIngredient[] var1);

    @ZenMethod
    public IZenRecipeBuilder setConsumeSecondaryIngredients(boolean var1);

    @ZenMethod
    public IZenRecipeBuilder setMirrored();

    @ZenMethod
    public IZenRecipeBuilder addTool(IIngredient var1, int var2);

    @ZenMethod
    public IZenRecipeBuilder addOutput(IItemStack var1, @Optional int var2);

    @ZenMethod
    public IZenRecipeBuilder setExtraOutputOne(IItemStack var1, float var2);

    @ZenMethod
    public IZenRecipeBuilder setExtraOutputTwo(IItemStack var1, float var2);

    @ZenMethod
    public IZenRecipeBuilder setExtraOutputThree(IItemStack var1, float var2);

    @ZenMethod
    public IZenRecipeBuilder setMinimumTier(int var1);

    @ZenMethod
    public IZenRecipeBuilder setMaximumTier(int var1);

    @ZenMethod
    public IZenRecipeBuilder setExperienceRequired(int var1);

    @ZenMethod
    public IZenRecipeBuilder setLevelRequired(int var1);

    @ZenMethod
    public IZenRecipeBuilder setConsumeExperience(boolean var1);

    @ZenMethod
    public IZenRecipeBuilder setHidden(@Optional(value="true", valueBoolean=true) boolean var1);

    @ZenMethod
    public IZenRecipeBuilder setRecipeFunction(IRecipeFunction var1);

    @ZenMethod
    public IZenRecipeBuilder setRecipeAction(IRecipeAction var1);

    @ZenMethod
    public IZenRecipeBuilder setCopy(IZenRecipeBuilderCopyStrategy var1);

    @ZenMethod
    public IZenRecipeBuilder addRequirement(IRequirementBuilder var1);

    @ZenMethod
    public IZenRecipeBuilder create();
}

