/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockMixed;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.IntCounter;
import scavenge.api.utils.JsonUtil;
import scavenge.api.world.IDelivered;

public class PropPerChunk
extends BaseResourceProperty
implements IResourceCondition,
IResourceEffect {
    String id;
    int usage;
    int max;
    int min;
    boolean decrease;

    public PropPerChunk(JsonObject obj) {
        super(obj, "per_chunk_limit");
        this.addIncompats("per_block_limit", "per_player_limit", "per_chunk_limit");
        this.id = JsonUtil.getOrDefault(obj, "id", null);
        if (JsonUtil.getOrDefault(obj, "increase", true)) {
            this.decrease = false;
            this.min = 0;
            this.max = obj.get("max").getAsInt();
            this.usage = JsonUtil.getOrDefault(obj, "usage", 1);
        } else {
            this.decrease = true;
            this.min = JsonUtil.getOrDefault(obj, "min", 0);
            this.max = obj.get("max").getAsInt();
            this.usage = JsonUtil.getOrDefault(obj, "usage", 1);
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        IntCounter counter = this.getHandler(world).getCounterPerChunk(this.id == null ? resourceID : this.id, pos).get();
        if (this.decrease) {
            if (counter.getCurrentValue() <= this.min) {
                world.func_175715_c(new ChunkPos(pos).hashCode(), pos, this.getValue(counter.getCurrentValue()));
                return false;
            }
        } else if (counter.getCurrentValue() >= this.max) {
            world.func_175715_c(new ChunkPos(pos).hashCode(), pos, 9);
            return false;
        }
        return true;
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        IDelivered<IntCounter> delivered = this.getHandler(world).getCounterPerChunk(this.id == null ? resourceID : this.id, pos);
        delivered.onChanged();
        IntCounter counter = delivered.get();
        if (this.decrease) {
            counter.decrease(this.usage, this.min);
            world.func_175715_c(new ChunkPos(pos).hashCode(), pos, this.getValue(counter.getCurrentValue()));
            return false;
        }
        counter.increase(this.usage);
        world.func_175715_c(new ChunkPos(pos).hashCode(), pos, this.getValue(counter.getCurrentValue()));
        return false;
    }

    public int getValue(int value) {
        float result = (float)value / (float)this.max;
        return (int)(result * 9.0f);
    }

    public static class PerChunkFactory
    extends BaseResourceFactory {
        public PerChunkFactory() {
            super("per_chunk_limit", IResourceFactory.PropertyType.ConditionEffect);
            this.setCompatState(CompatState.INCOMPATIBLE);
            this.addIncompat("per_player_limit", CompatState.INCOMPATIBLE);
            this.addIncompat("per_block_limit", CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPerChunk(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("id", "ResourceID", "Custom ID for the Counter for the per Chunk Data"));
            map.addElement(new BooleanElement("increase", true, "If the it should be used up or reduced"));
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new IntElement("usage", 1, "How much the Value should increase"));
            choice.addElement(0, new IntElement("max", 0).setDescription("How much the limit should be"));
            choice.addElement(1, new IntElement("usage", 1, "How much the Value should decrease"));
            choice.addElement(1, new IntElement("max", 0).setDescription("What the max should be (for the progress-animation)"));
            choice.addElement(1, new IntElement("min", 0, "What the lower value should be."));
            map.addElement(choice);
            map.setDescription("Allows to limit the Usage of a Block per Chunk");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("usage", (Number)1);
            obj.addProperty("max", (Number)20);
        }
    }
}

