/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.ScavengeAPI;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.BlockEntry;
import scavenge.api.utils.JsonUtil;

public class PropConsumeBlock
extends BaseResourceProperty
implements IResourceEffect {
    BlockEntry replacement;
    boolean custom;
    double chance;
    boolean drop;

    public PropConsumeBlock(JsonObject obj) {
        super(obj, "consume_block");
        this.chance = JsonUtil.getOrDefault(obj, "chance", 100.0);
        this.drop = JsonUtil.getOrDefault(obj, "dropBlock", false);
        if (obj.has("name")) {
            this.replacement = JsonUtil.createBlockWithMeta(obj);
            if (this.replacement == null) {
                throw new RuntimeException("BlockName [" + obj.get("name").getAsString() + "] ");
            }
            this.setJEIInfo("Transforms the Block into [" + this.replacement.getName() + "] with a [" + this.chance + "%] chance");
            this.custom = this.replacement.getBlock() != Blocks.field_150350_a;
        } else {
            this.replacement = new BlockEntry(Blocks.field_150350_a, 0);
            this.setJEIInfo("Consumes the block with a [" + this.chance + "%] chance");
            this.custom = false;
        }
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        super.addJEIData(collector);
        if (this.custom && this.replacement.hasItemBlock()) {
            collector.addTransformation(this.replacement.toStack(), this.chance);
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.chance >= world.field_73012_v.nextDouble() * 100.0) {
            if (this.drop) {
                state.func_177230_c().func_176226_b(world, pos, state, 0);
            }
            world.func_175656_a(pos, this.replacement.getBlockState());
            ScavengeAPI.INSTANCE.getWorldRegistry().getStorageForWorld(world).removeBlockUnbreaking(pos);
            return true;
        }
        return false;
    }

    public static class ConsumeBlockFactory
    extends BaseResourceFactory {
        public ConsumeBlockFactory() {
            super("consume_block", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropConsumeBlock(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to consume the Clicked block or to transform it into another block");
            map.addElement(new DoubleElement("chance", 100.0, "How likely it is that the block gets consumed or transformed"));
            map.addElement(new TextElement("name", "minecraft:air", "What Block Replacement block should be"));
            map.addElement(new IntElement("meta", 0, "Which metadata the block should have"));
            map.addElement(new BooleanElement("dropBlock", false, "If the Block should drop or not"));
            return map;
        }
    }
}

