/*
 * Decompiled with CFR 0.152.
 */
package scavenge.tileentity.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropModifyTileFE
extends BaseResourceProperty
implements IResourceEffect {
    boolean consume;
    int amount;

    public PropModifyTileFE(JsonObject obj) {
        super(obj, "modify_Block_FE");
        this.consume = JsonUtil.getOrDefault(obj, "consume", true);
        this.amount = JsonUtil.getOrDefault(obj, "amount", 0);
        if (this.consume) {
            this.setJEIInfo("Consumes " + this.amount + " FE from the BlockTileEntity");
        } else {
            this.setJEIInfo("Adds " + this.amount + " FE to the BlockTileEntity");
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || tile.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return false;
        }
        IEnergyStorage handler = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, null);
        if (this.consume && handler.canExtract()) {
            return handler.extractEnergy(this.amount, false) > 0;
        }
        if (!this.consume && handler.canReceive()) {
            return handler.receiveEnergy(this.amount, false) > 0;
        }
        return false;
    }

    public static class ModifyTileFEFactory
    extends BaseResourceFactory {
        public ModifyTileFEFactory() {
            super("modify_Block_FE", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropModifyTileFE(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("consume", Boolean.valueOf(true));
            obj.addProperty("amount", (Number)1000);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new BooleanElement("consume", true, "If Forge Energy should be added or removed"));
            map.addElement(new IntElement("amount", 0, "How much should be added or removed"));
            map.setDescription("Allows to add or remove FE to a BlockTileEntity");
            return map;
        }
    }
}

