/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.MathUtils;

public class PropAddXPLevel
extends BaseResourceProperty
implements IResourceEffect {
    boolean remove;
    int amount;

    public PropAddXPLevel(JsonObject obj) {
        super(obj, "add_XP_Level");
        this.remove = JsonUtil.getOrDefault(obj, "remove", false);
        this.amount = obj.get("amount").getAsInt();
        if (this.remove) {
            this.setJEIInfo("Removes " + this.amount + " XP Levels to the Player");
        } else {
            this.setJEIInfo("Adds " + this.amount + " XP Levels to the Player");
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.remove) {
            int extraXP = (int)((float)player.func_71050_bK() * player.field_71106_cc);
            player.field_71068_ca -= this.amount;
            player.field_71067_cb = MathUtils.getXPForLvl(player.field_71068_ca);
            player.field_71106_cc = 0.0f;
            player.func_71023_q(extraXP);
        }
        player.func_82242_a(this.amount);
        return false;
    }

    public static class AddXPLevelFactory
    extends BaseResourceFactory {
        public AddXPLevelFactory() {
            super("add_XP_Level", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropAddXPLevel(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("amount", (Number)100);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new IntElement("amount", 0).setDescription("How many XP Levels should be added or removed"));
            map.addElement(new BooleanElement("remove", false, "If XP Levels should be added or Removed"));
            map.setDescription("Allows to Add or Remove XP Levels");
            return map;
        }
    }
}

