/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.mixed;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseActiveLootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.utils.JsonUtil;

public class PropHasFlag
extends BaseActiveLootProperty {
    String tagID;
    boolean value;
    ILootProperty prop;

    public PropHasFlag(JsonObject obj) {
        super("set_has_flag");
        this.tagID = obj.get("flagID").getAsString();
        this.value = JsonUtil.getOrDefault(obj, "value", true);
        this.prop = this.createLoot(obj.getAsJsonObject("loot"));
    }

    @Override
    public ItemStack applyActiveEffect(ItemStack stack, NBTTagCompound customData) {
        if (customData.func_74764_b(this.tagID) && customData.func_74767_n(this.tagID) == this.value) {
            if (this.prop.isActiveProperty()) {
                return this.prop.applyActiveEffect(stack, customData);
            }
            this.prop.applyPassiveEffect(stack);
        }
        return stack;
    }

    @Override
    public List<ItemStack> applyMultiInfoEffect(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(stack.func_77946_l());
        if (this.prop.hasMultiResults()) {
            list.addAll(this.prop.applyMultiInfoEffect(stack));
        } else {
            list.add(this.prop.applyInfoEffect(stack));
        }
        return list;
    }

    public static class HasFlagFactory
    extends BaseLootFactory {
        public HasFlagFactory() {
            super("set_has_flag", true);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropHasFlag(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new TextElement("flagID", "").setDescription("The ID of the the Flag that should be checkt for"));
            map.addElement(new BooleanElement("value", true, "If The Flag has to be true or false"));
            map.addElement(new MapElement("loot").setDescription("The LootProperty that should be applied"));
            map.setDescription("Allows to add a LootProperty based on Data thats being send from the Block Property (sendFlagToLoot)");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject data = new JsonObject();
            data.addProperty("type", "lootID");
            obj.add("loot", (JsonElement)data);
            obj.addProperty("flagID", "CustomFlagID");
        }
    }
}

