/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.handlers;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import scavenge.api.IScavengeFactory;
import scavenge.api.ScavengeAPI;
import scavenge.api.math.IMathModifier;
import scavenge.api.math.IMathOperation;
import scavenge.api.math.IMathRegistry;

public class MathRegistry
implements IMathRegistry {
    Map<String, IScavengeFactory<IMathOperation>> operationFactories = new LinkedHashMap<String, IScavengeFactory<IMathOperation>>();
    Map<String, IScavengeFactory<IMathModifier>> modifierFactories = new LinkedHashMap<String, IScavengeFactory<IMathModifier>>();

    @Override
    public void registerOperationFactory(IScavengeFactory<IMathOperation> factory) {
        String id = factory.getID();
        if (id == null || id.isEmpty()) {
            ScavengeAPI.APILogger.error("Factory [" + factory.toString() + "] provided");
            return;
        }
        if (this.operationFactories.containsKey(id = id.toLowerCase(Locale.ENGLISH))) {
            ScavengeAPI.APILogger.error("Factory ID [" + id + "] for factory [" + factory.toString() + "] is already being used!");
            return;
        }
        this.operationFactories.put(id, factory);
    }

    @Override
    public void registerModifierFactory(IScavengeFactory<IMathModifier> factory) {
        String id = factory.getID();
        if (id == null || id.isEmpty()) {
            ScavengeAPI.APILogger.error("Factory [" + factory.toString() + "] provided");
            return;
        }
        if (this.modifierFactories.containsKey(id = id.toLowerCase(Locale.ENGLISH))) {
            ScavengeAPI.APILogger.error("Factory ID [" + id + "] for factory [" + factory.toString() + "] is already being used!");
            return;
        }
        this.modifierFactories.put(id, factory);
    }

    @Override
    public IMathOperation getOperation(String id, JsonObject obj) {
        IScavengeFactory<IMathOperation> factory = this.operationFactories.get(id.toLowerCase(Locale.ENGLISH));
        if (factory == null) {
            throw new RuntimeException("ID [" + id + "] has no factory!");
        }
        return factory.createObject(obj);
    }

    @Override
    public IMathModifier getModifier(String id, JsonObject obj) {
        IScavengeFactory<IMathModifier> factory = this.modifierFactories.get(id.toLowerCase(Locale.ENGLISH));
        if (factory == null) {
            throw new RuntimeException("ID [" + id + "] has no factory!");
        }
        return factory.createObject(obj);
    }

    @Override
    public List<IScavengeFactory<IMathOperation>> getOperations() {
        return new ArrayList<IScavengeFactory<IMathOperation>>(this.operationFactories.values());
    }

    @Override
    public List<IScavengeFactory<IMathModifier>> getModifiers() {
        return new ArrayList<IScavengeFactory<IMathModifier>>(this.modifierFactories.values());
    }
}

