/*
 * Decompiled with CFR 0.152.
 */
package scavenge.api.autodoc;

import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.List;
import scavenge.api.autodoc.BaseElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.MapElement;

public class ArrayElement
extends BaseElement<String> {
    List<BaseElement> elements = new ArrayList<BaseElement>();
    Class<? extends BaseElement> elementType;

    public ArrayElement(String id) {
        super(id);
        this.setType("MixedArray");
        this.elementType = null;
    }

    public ArrayElement(String id, BaseElement base) {
        super(id);
        this.setType(base.getType() + "Array");
        this.elementType = base.getClass();
    }

    public ArrayElement addElement(BaseElement element) {
        if (this.elementType == null || this.elementType.isInstance(element)) {
            this.elements.add(element);
        }
        return this;
    }

    @Override
    public boolean isMultiElement() {
        return false;
    }

    @Override
    public String getValue() {
        return "";
    }

    @Override
    public void writeToBuffer(BufferedWriter writer, boolean showSelf, int layer, boolean printCurse) throws Exception {
        BaseElement element;
        super.writeToBuffer(writer, showSelf, layer, printCurse);
        if (this.elementType == null) {
            for (BaseElement element2 : this.elements) {
                element2.writeToBuffer(writer, false, layer + 1, printCurse);
            }
        } else if (this.elements.size() > 0 && ((element = this.elements.get(0)) instanceof MapElement || element instanceof ChoiceElement || element instanceof ArrayElement)) {
            element.writeToBuffer(writer, false, layer + 1, printCurse);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.elements.size(); ++i) {
            builder.append(this.elements.get(i));
            if (this.elements.size() - 1 <= i) continue;
            builder.append(", ");
        }
        return "Array[ID=" + this.key + ",value=<" + builder.toString() + ">]";
    }
}

