/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.powercell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.TeleportationTools;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftools.RFTools;
import mcjty.rftools.apideps.RFToolsDimensionChecker;
import mcjty.rftools.blocks.powercell.PowerCellBlock;
import mcjty.rftools.blocks.powercell.PowerCellConfiguration;
import mcjty.rftools.blocks.powercell.PowerCellSetup;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class PowerCellNetwork
extends AbstractWorldData<PowerCellNetwork> {
    private static final String POWERCELL_NETWORK_NAME = "RFToolsPowerCellNetwork";
    private int lastId = 0;
    private final Map<Integer, Network> networks = new HashMap<Integer, Network>();

    public PowerCellNetwork(String name) {
        super(name);
    }

    public void clear() {
        this.networks.clear();
        this.lastId = 0;
    }

    public static PowerCellNetwork getChannels(World world) {
        return (PowerCellNetwork)PowerCellNetwork.getData((World)world, PowerCellNetwork.class, (String)POWERCELL_NETWORK_NAME);
    }

    public Network getOrCreateNetwork(int id) {
        Network channel = this.networks.get(id);
        if (channel == null) {
            channel = new Network();
            this.networks.put(id, channel);
        }
        return channel;
    }

    public Network getChannel(int id) {
        return this.networks.get(id);
    }

    public void deleteChannel(int id) {
        this.networks.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.networks.clear();
        NBTTagList lst = tagCompound.func_150295_c("networks", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int channel = tc.func_74762_e("channel");
            Network value = new Network();
            value.readFromNBT(tc);
            this.networks.put(channel, value);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, Network> entry : this.networks.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("channel", entry.getKey().intValue());
            entry.getValue().writeToNBT(tc);
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("networks", (NBTBase)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    public static class Network {
        private int energy = 0;
        private Set<GlobalCoordinate> blocks = new HashSet<GlobalCoordinate>();
        private int simpleBlocks = 0;
        private int advancedBlocks = 0;
        private Map<GlobalCoordinate, Float> costFactor = null;

        public Set<GlobalCoordinate> getBlocks() {
            return this.blocks;
        }

        public int getBlockCount() {
            return this.blocks.size();
        }

        public int getAdvancedBlockCount() {
            return this.advancedBlocks;
        }

        public int getSimpleBlockCount() {
            return this.simpleBlocks;
        }

        public int calculateMaximumEnergy() {
            long totEnergyLong = (long)PowerCellConfiguration.rfPerNormalCell * (long)(this.getBlockCount() - this.getAdvancedBlockCount() - this.getSimpleBlockCount()) + (long)PowerCellConfiguration.rfPerNormalCell * (long)PowerCellConfiguration.advancedFactor * (long)this.getAdvancedBlockCount() + (long)PowerCellConfiguration.rfPerNormalCell * (long)this.getSimpleBlockCount() / (long)PowerCellConfiguration.simpleFactor;
            if (totEnergyLong > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)totEnergyLong;
        }

        public void updateNetwork(World w) {
            this.advancedBlocks = 0;
            this.simpleBlocks = 0;
            HashSet<GlobalCoordinate> copy = new HashSet<GlobalCoordinate>(this.blocks);
            this.blocks.clear();
            for (GlobalCoordinate c : copy) {
                World world = TeleportationTools.getWorldForDimension((int)c.getDimension());
                IBlockState state = world.func_180495_p(c.getCoordinate());
                if (state.func_177230_c() == PowerCellSetup.powerCellBlock) {
                    this.blocks.add(c);
                    continue;
                }
                if (PowerCellBlock.isAdvanced(state.func_177230_c())) {
                    this.blocks.add(c);
                    ++this.advancedBlocks;
                    continue;
                }
                if (PowerCellBlock.isSimple(state.func_177230_c())) {
                    this.blocks.add(c);
                    ++this.simpleBlocks;
                    continue;
                }
                Logging.log((String)"Warning! Powercell network data was not up-to-date!");
            }
        }

        public void add(World world, GlobalCoordinate g, boolean advanced, boolean simple) {
            if (!this.blocks.contains(g)) {
                this.blocks.add(g);
                this.costFactor = null;
                if (advanced) {
                    ++this.advancedBlocks;
                }
                if (simple) {
                    ++this.simpleBlocks;
                }
                this.updateNetwork(world);
            }
        }

        public void remove(World world, GlobalCoordinate g, boolean advanced, boolean simple) {
            if (this.blocks.contains(g)) {
                this.blocks.remove(g);
                this.costFactor = null;
                if (advanced) {
                    --this.advancedBlocks;
                }
                if (simple) {
                    --this.simpleBlocks;
                }
                this.updateNetwork(world);
            }
        }

        private double calculateBlobDistance(World world, Set<GlobalCoordinate> blob1, Set<GlobalCoordinate> blob2) {
            GlobalCoordinate c1 = blob1.iterator().next();
            GlobalCoordinate c2 = blob2.iterator().next();
            boolean dim1rftools = RFTools.instance.rftoolsDimensions && RFToolsDimensionChecker.isRFToolsDimension(world, c1.getDimension());
            boolean dim2rftools = RFTools.instance.rftoolsDimensions && RFToolsDimensionChecker.isRFToolsDimension(world, c2.getDimension());
            double rftoolsdimMult = 1.0;
            if (dim1rftools) {
                rftoolsdimMult *= PowerCellConfiguration.powerCellRFToolsDimensionAdvantage;
            }
            if (dim2rftools) {
                rftoolsdimMult *= PowerCellConfiguration.powerCellRFToolsDimensionAdvantage;
            }
            if (c1.getDimension() != c2.getDimension()) {
                return PowerCellConfiguration.powerCellDistanceCap * rftoolsdimMult;
            }
            double dist = Math.sqrt(c1.getCoordinate().func_177951_i((Vec3i)c2.getCoordinate()));
            if (dist > PowerCellConfiguration.powerCellDistanceCap) {
                dist = PowerCellConfiguration.powerCellDistanceCap;
            } else if (dist < PowerCellConfiguration.powerCellMinDistance) {
                dist = PowerCellConfiguration.powerCellMinDistance;
            }
            return dist * rftoolsdimMult;
        }

        private void updateCostFactor(World world) {
            if (this.costFactor == null) {
                this.costFactor = new HashMap<GlobalCoordinate, Float>();
                ArrayList<Set<GlobalCoordinate>> blobs = new ArrayList<Set<GlobalCoordinate>>();
                this.getBlobs(blobs);
                for (Set set : blobs) {
                    double totalfactor = 1.0;
                    for (Set set2 : blobs) {
                        if (set2 == set) continue;
                        double dist = this.calculateBlobDistance(world, set, set2);
                        double part = (double)set2.size() / (double)this.blocks.size();
                        double factor = 1.0 + dist / PowerCellConfiguration.powerCellDistanceCap * (PowerCellConfiguration.powerCellCostFactor - 1.0) * part;
                        totalfactor += factor;
                    }
                    totalfactor /= (double)blobs.size();
                    for (GlobalCoordinate globalCoordinate : set) {
                        this.costFactor.put(globalCoordinate, Float.valueOf((float)totalfactor));
                    }
                }
            }
        }

        private void getBlob(Set<GlobalCoordinate> todo, Set<GlobalCoordinate> blob, GlobalCoordinate coordinate) {
            blob.add(coordinate);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                GlobalCoordinate offset = new GlobalCoordinate(coordinate.getCoordinate().func_177972_a(facing), coordinate.getDimension());
                if (!todo.contains(offset)) continue;
                todo.remove(offset);
                this.getBlob(todo, blob, offset);
            }
        }

        private void getBlobs(List<Set<GlobalCoordinate>> blobs) {
            HashSet<GlobalCoordinate> todo = new HashSet<GlobalCoordinate>(this.blocks);
            while (!todo.isEmpty()) {
                GlobalCoordinate coordinate = (GlobalCoordinate)todo.iterator().next();
                todo.remove(coordinate);
                HashSet<GlobalCoordinate> blob = new HashSet<GlobalCoordinate>();
                this.getBlob(todo, blob, coordinate);
                blobs.add(blob);
            }
        }

        public float calculateCostFactor(World world, GlobalCoordinate g) {
            this.updateCostFactor(world);
            Float f = this.costFactor.get(g);
            return f == null ? 1.0f : f.floatValue();
        }

        public int getEnergySingleBlock(boolean advanced, boolean simple) {
            int simpleBlockCount = Math.max(1, (this.blocks.size() - this.advancedBlocks - this.simpleBlocks) * PowerCellConfiguration.simpleFactor + this.advancedBlocks * PowerCellConfiguration.advancedFactor * PowerCellConfiguration.simpleFactor + this.simpleBlocks);
            long rc = this.energy / simpleBlockCount;
            if (advanced) {
                rc *= (long)(PowerCellConfiguration.advancedFactor * PowerCellConfiguration.simpleFactor);
            } else if (!simple) {
                rc *= (long)PowerCellConfiguration.simpleFactor;
            }
            return rc > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)rc;
        }

        public int extractEnergySingleBlock(boolean advanced, boolean simple) {
            return this.extractEnergy(this.getEnergySingleBlock(advanced, simple));
        }

        public int getEnergy() {
            return this.energy;
        }

        public int extractEnergy(int amount) {
            if (amount > this.energy) {
                amount = this.energy;
            }
            this.energy -= amount;
            return amount;
        }

        public int receiveEnergy(int amount) {
            if (amount > Integer.MAX_VALUE - this.energy) {
                amount = Integer.MAX_VALUE - this.energy;
            }
            this.energy += amount;
            return amount;
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }

        public void writeToNBT(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("energy", this.energy);
            tagCompound.func_74768_a("advanced", this.advancedBlocks);
            tagCompound.func_74768_a("simple", this.simpleBlocks);
            NBTTagList list = new NBTTagList();
            for (GlobalCoordinate block : this.blocks) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("dim", block.getDimension());
                tag.func_74768_a("x", block.getCoordinate().func_177958_n());
                tag.func_74768_a("y", block.getCoordinate().func_177956_o());
                tag.func_74768_a("z", block.getCoordinate().func_177952_p());
                list.func_74742_a((NBTBase)tag);
            }
            tagCompound.func_74782_a("blocks", (NBTBase)list);
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            this.energy = tagCompound.func_74762_e("energy");
            this.advancedBlocks = tagCompound.func_74762_e("advanced");
            this.simpleBlocks = tagCompound.func_74762_e("simple");
            this.blocks.clear();
            NBTTagList list = tagCompound.func_150295_c("blocks", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                this.blocks.add(new GlobalCoordinate(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")), tag.func_74762_e("dim")));
            }
        }
    }
}

