/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.ogex;

import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTransform;
import javax.vecmath.Vector3f;

public class OgexMatrixTransform
implements OgexTransform {
    private float[] matrix;
    private boolean object;
    static final int m00 = 0;
    static final int m01 = 1;
    static final int m02 = 2;
    static final int m03 = 3;
    static final int m10 = 4;
    static final int m11 = 5;
    static final int m12 = 6;
    static final int m13 = 7;
    static final int m20 = 8;
    static final int m21 = 9;
    static final int m22 = 10;
    static final int m23 = 11;
    static final int m30 = 12;
    static final int m31 = 13;
    static final int m32 = 14;
    static final int m33 = 15;

    @Override
    public void setObjectOnly(boolean b) {
        this.object = b;
    }

    @Override
    public boolean isObjectOnly() {
        return this.object;
    }

    public void setMatrix(float[] matrix) {
        this.matrix = OgexMatrixTransform.transpose(matrix);
    }

    public float[] getMatrix() {
        return this.matrix;
    }

    @Override
    public float[] toMatrix() {
        return (float[])this.matrix.clone();
    }

    public static float[] transpose(float[] array) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < i; ++j) {
                float swap = array[i * 4 + j];
                array[i * 4 + j] = array[j * 4 + i];
                array[j * 4 + i] = swap;
            }
        }
        return array;
    }

    public static float[] identity() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] multiply(float[] left, float[] right) {
        float n00 = left[0] * right[0] + left[1] * right[4] + left[2] * right[8] + left[3] * right[12];
        float n01 = left[0] * right[1] + left[1] * right[5] + left[2] * right[9] + left[3] * right[13];
        float n02 = left[0] * right[2] + left[1] * right[6] + left[2] * right[10] + left[3] * right[14];
        float n03 = left[0] * right[3] + left[1] * right[7] + left[2] * right[11] + left[3] * right[15];
        float n10 = left[4] * right[0] + left[5] * right[4] + left[6] * right[8] + left[7] * right[12];
        float n11 = left[4] * right[1] + left[5] * right[5] + left[6] * right[9] + left[7] * right[13];
        float n12 = left[4] * right[2] + left[5] * right[6] + left[6] * right[10] + left[7] * right[14];
        float n13 = left[4] * right[3] + left[5] * right[7] + left[6] * right[11] + left[7] * right[15];
        float n20 = left[8] * right[0] + left[9] * right[4] + left[10] * right[8] + left[11] * right[12];
        float n21 = left[8] * right[1] + left[9] * right[5] + left[10] * right[9] + left[11] * right[13];
        float n22 = left[8] * right[2] + left[9] * right[6] + left[10] * right[10] + left[11] * right[14];
        float n23 = left[8] * right[3] + left[9] * right[7] + left[10] * right[11] + left[11] * right[15];
        float n30 = left[12] * right[0] + left[13] * right[4] + left[14] * right[8] + left[15] * right[12];
        float n31 = left[12] * right[1] + left[13] * right[5] + left[14] * right[9] + left[15] * right[13];
        float n32 = left[12] * right[2] + left[13] * right[6] + left[14] * right[10] + left[15] * right[14];
        float n33 = left[12] * right[3] + left[13] * right[7] + left[14] * right[11] + left[15] * right[15];
        return new float[]{n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33};
    }

    public String toString() {
        if (this.matrix == null) {
            return this.getClass().getSimpleName() + "[]";
        }
        StringBuilder sb = new StringBuilder();
        for (float f : this.matrix) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(f);
        }
        return this.getClass().getSimpleName() + "[" + sb + "]";
    }

    public static void applyTo(float[] transform, Vector3f vec) {
        float x = transform[0] * vec.x + transform[1] * vec.y + transform[2] * vec.z;
        float y = transform[4] * vec.x + transform[5] * vec.y + transform[6] * vec.z;
        float z = transform[8] * vec.x + transform[9] * vec.y + transform[10] * vec.z;
        vec.x = x + transform[3];
        vec.y = y + transform[7];
        vec.z = z + transform[11];
    }
}

