/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.gauge;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.gauge.RenderMapperGauge;
import crazypants.enderio.powertools.machine.gauge.TESRGauge;
import crazypants.enderio.powertools.machine.gauge.TileGauge;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGauge
extends BlockEio<TileGauge>
implements IResourceTooltipProvider,
ISmartRenderAwareBlock,
IHaveTESR {
    public static final TextureRegistry.TextureSupplier gaugeIcon = TextureRegistry.registerTexture((String)"blocks/block_gauge_overlay");
    private static final double px = 0.0625;

    public static BlockGauge create(@Nonnull IModObject modObject) {
        BlockGauge result = new BlockGauge(modObject);
        result.init();
        return result;
    }

    private BlockGauge(@Nonnull IModObject modObject) {
        super(modObject, Material.field_151592_s);
        this.func_149713_g(255);
        this.field_149783_u = true;
        this.setShape(this.mkShape(BlockFaceShape.UNDEFINED));
    }

    protected void init() {
        super.init();
        SmartModelAttacher.registerItemOnly((Block)this);
    }

    public void func_149666_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(tab, list);
        }
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState bs) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState bs) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        Map<EnumFacing, IPowerInterface> sides = BlockGauge.getDisplays(world, pos);
        if (sides.isEmpty()) {
            return field_185505_j;
        }
        double minX = 1.0;
        double maxX = 0.0;
        double minY = 0.125;
        double maxY = 0.875;
        double minZ = 1.0;
        double maxZ = 0.0;
        if (sides.containsKey(EnumFacing.NORTH) || sides.containsKey(EnumFacing.SOUTH)) {
            minX = Math.min(minX, 0.375);
            maxX = Math.max(maxX, 0.625);
            if (sides.containsKey(EnumFacing.NORTH)) {
                minZ = Math.min(minZ, 0.0);
                maxZ = Math.max(maxZ, 0.03125);
            }
            if (sides.containsKey(EnumFacing.SOUTH)) {
                minZ = Math.min(minZ, 0.96875);
                maxZ = Math.max(maxZ, 1.0);
            }
        }
        if (sides.containsKey(EnumFacing.EAST) || sides.containsKey(EnumFacing.WEST)) {
            minZ = Math.min(minZ, 0.375);
            maxZ = Math.max(maxZ, 0.625);
            if (sides.containsKey(EnumFacing.WEST)) {
                minX = Math.min(minX, 0.0);
                maxX = Math.max(maxX, 0.09375);
            }
            if (sides.containsKey(EnumFacing.EAST)) {
                minX = Math.min(minX, 0.96875);
                maxX = Math.max(maxX, 1.0);
            }
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nonnull
    protected static Map<EnumFacing, IPowerInterface> getDisplays(final @Nonnull IBlockAccess world, final @Nonnull BlockPos pos) {
        final EnumMap<EnumFacing, IPowerInterface> sides = new EnumMap<EnumFacing, IPowerInterface>(EnumFacing.class);
        NNList.FACING_HORIZONTAL.apply((NNList.Callback)new NNList.Callback<EnumFacing>(){

            public void apply(@Nonnull EnumFacing face) {
                BlockPos neighbor = pos.func_177972_a(face);
                TileEntity tile = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)neighbor);
                if (!(tile instanceof TileCapBank) && !(tile instanceof IConduitBundle)) {
                    IPowerInterface eh = PowerHandlerUtil.getPowerInterface((ICapabilityProvider)tile, (EnumFacing)face.func_176734_d());
                    if (eh != null) {
                        sides.put(face, eh);
                        return;
                    }
                    eh = PowerHandlerUtil.getPowerInterface((ICapabilityProvider)tile, (EnumFacing)EnumFacing.DOWN);
                    if (eh != null) {
                        sides.put(face, eh);
                        return;
                    }
                }
            }
        });
        return sides;
    }

    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockStateIn, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return null;
    }

    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMapperGauge.instance;
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.func_149739_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileGauge.class, (TileEntitySpecialRenderer)new TESRGauge());
    }
}

