/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.net;

import com.feed_the_beast.ftblib.client.teamsgui.GuiManageAllies;
import com.feed_the_beast.ftblib.client.teamsgui.GuiManageEnemies;
import com.feed_the_beast.ftblib.client.teamsgui.GuiManageMembers;
import com.feed_the_beast.ftblib.client.teamsgui.GuiManageModerators;
import com.feed_the_beast.ftblib.client.teamsgui.GuiTransferOwnership;
import com.feed_the_beast.ftblib.lib.EnumTeamStatus;
import com.feed_the_beast.ftblib.lib.data.FTBLibTeamGuiActions;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftblib.net.FTBLibNetHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageMyTeamPlayerList
extends MessageToClient {
    private ResourceLocation id;
    private Collection<Entry> entries;

    public MessageMyTeamPlayerList() {
    }

    public MessageMyTeamPlayerList(ResourceLocation _id, ForgePlayer player, Predicate<EnumTeamStatus> predicate) {
        this.id = _id;
        this.entries = new ArrayList<Entry>();
        for (ForgePlayer p : player.team.universe.getPlayers()) {
            EnumTeamStatus status;
            if (p == player || (status = player.team.getHighestStatus(p)) == EnumTeamStatus.OWNER || !predicate.test(status)) continue;
            this.entries.add(new Entry(p, status, player.team.isRequestingInvite(p)));
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.MY_TEAM;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeResourceLocation(this.id);
        data.writeCollection(this.entries, Entry.SERIALIZER);
    }

    @Override
    public void readData(DataIn data) {
        this.id = data.readResourceLocation();
        this.entries = data.readCollection(Entry.DESERIALIZER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        if (this.id.equals((Object)FTBLibTeamGuiActions.MEMBERS.getId())) {
            new GuiManageMembers(this.entries).openGui();
        } else if (this.id.equals((Object)FTBLibTeamGuiActions.ALLIES.getId())) {
            new GuiManageAllies(this.entries).openGui();
        } else if (this.id.equals((Object)FTBLibTeamGuiActions.MODERATORS.getId())) {
            new GuiManageModerators(this.entries).openGui();
        } else if (this.id.equals((Object)FTBLibTeamGuiActions.ENEMIES.getId())) {
            new GuiManageEnemies(this.entries).openGui();
        } else if (this.id.equals((Object)FTBLibTeamGuiActions.TRANSFER_OWNERSHIP.getId())) {
            new GuiTransferOwnership(this.entries).openGui();
        }
    }

    public static class Entry
    implements Comparable<Entry> {
        private static final DataOut.Serializer<Entry> SERIALIZER = (data, object) -> object.writeData(data);
        private static final DataIn.Deserializer<Entry> DESERIALIZER = Entry::new;
        public final UUID uuid;
        public final String name;
        public EnumTeamStatus status;
        public boolean requestingInvite;

        private Entry(DataIn data) {
            this.uuid = data.readUUID();
            this.name = data.readString();
            this.status = data.read(EnumTeamStatus.NAME_MAP);
            this.requestingInvite = data.readBoolean();
        }

        public Entry(ForgePlayer player, EnumTeamStatus s, boolean i) {
            this.uuid = player.getId();
            this.name = player.getDisplayNameString();
            this.status = s;
            this.requestingInvite = i;
        }

        private void writeData(DataOut data) {
            data.writeUUID(this.uuid);
            data.writeString(this.name);
            data.write(this.status, EnumTeamStatus.NAME_MAP);
            data.writeBoolean(this.requestingInvite);
        }

        public int getSortIndex() {
            return this.requestingInvite ? 1000 : Math.max(this.status.getStatus(), this.status == EnumTeamStatus.ENEMY ? 1 : 0);
        }

        @Override
        public int compareTo(Entry o) {
            int o2s;
            int o1s = this.getSortIndex();
            return o1s == (o2s = o.getSortIndex()) ? this.name.compareToIgnoreCase(o.name) : o2s - o1s;
        }
    }
}

