/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection.transfer;

import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.energy.EnergyType;
import sonar.core.helpers.NBTHelper;
import sonar.flux.api.energy.internal.IFluxTransfer;

public abstract class BaseFluxTransfer
implements IFluxTransfer {
    public EnergyType energy_type;
    public long added = 0L;
    public long removed = 0L;

    public BaseFluxTransfer(EnergyType type) {
        this.energy_type = type;
    }

    @Override
    public void onStartServerTick() {
        this.added = 0L;
        this.removed = 0L;
    }

    @Override
    public void onEndWorldTick() {
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.setEnergyType(EnergyType.readFromNBT((NBTTagCompound)nbt, (String)"ET"));
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        EnergyType.writeToNBT((EnergyType)this.getEnergyType(), (NBTTagCompound)nbt, (String)"ET");
        return nbt;
    }

    @Override
    public final void addedToNetwork(long add, EnergyType energyType) {
        this.added += add;
        this.onTransferAdded(add);
    }

    @Override
    public final void removedFromNetwork(long remove, EnergyType energyType) {
        this.removed += remove;
        this.onTransferRemoved(remove);
    }

    public void onTransferAdded(long add) {
    }

    public void onTransferRemoved(long remove) {
    }

    @Override
    public EnergyType getEnergyType() {
        return this.energy_type;
    }

    public void setEnergyType(EnergyType type) {
        this.energy_type = type;
    }
}

