/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui.tabs;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import sonar.core.api.energy.EnergyType;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.CustomColour;
import sonar.flux.FluxTranslate;
import sonar.flux.api.AccessType;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.client.gui.GuiTabAbstract;
import sonar.flux.client.gui.buttons.LargeButton;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.PacketGeneralHelper;
import sonar.flux.network.PacketGeneralType;

public class GuiTabNetworkEdit
extends GuiTabAbstract {
    public SonarTextField name;
    public SonarTextField r;
    public SonarTextField g;
    public SonarTextField b;
    public int currentColour;
    public AccessType currentAccess = AccessType.PRIVATE;
    public boolean previewSelected = true;
    public boolean showFullPreview = true;
    public boolean enableConversion = true;
    public EnergyType type = EnergyType.FE;

    public GuiTabNetworkEdit(List<EnumGuiTab> tabs) {
        super(tabs);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.getCurrentTab() == EnumGuiTab.NETWORK_CREATE) {
            this.initEditFields(this.field_146297_k.field_71439_g.func_70005_c_() + "'s Network", colours[this.currentColour]);
            this.field_146292_n.add(new LargeButton(this, FluxTranslate.RESET.t(), 5, this.getGuiLeft() + 55, this.getGuiTop() + 134, 68, 0));
            this.field_146292_n.add(new LargeButton(this, FluxTranslate.CREATE.t(), 6, this.getGuiLeft() + 105, this.getGuiTop() + 134, 51, 0));
        } else if (!this.common.isFakeNetwork()) {
            this.initEditFields(NetworkSettings.NETWORK_NAME.getValue(this.common), NetworkSettings.NETWORK_COLOUR.getValue(this.common));
            this.field_146292_n.add(new LargeButton(this, FluxTranslate.RESET.t(), 5, this.getGuiLeft() + 55, this.getGuiTop() + 134, 68, 0));
            this.field_146292_n.add(new LargeButton(this, FluxTranslate.SAVE_CHANGE.t(), 6, this.getGuiLeft() + 105, this.getGuiTop() + 134, 17, 0));
            this.currentAccess = NetworkSettings.NETWORK_ACCESS.getValue(this.common);
            this.enableConversion = NetworkSettings.NETWORK_CONVERSION.getValue(this.common);
            this.type = NetworkSettings.NETWORK_ENERGY_TYPE.getValue(this.common);
        } else {
            this.disabled = true;
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.disabled) {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_NETWORK_TO_EDIT.t(), FluxTranslate.GUI_TAB_NETWORK_SELECTION.t());
        } else {
            GlStateManager.func_179094_E();
            FontHelper.textCentre((String)this.getCurrentTab().getClientName(), (int)this.field_146999_f, (int)8, (int)Color.GRAY.getRGB());
            FontHelper.text((String)(FluxTranslate.NAME.t() + ": "), (int)8, (int)24, (int)0);
            FontHelper.text((String)(FluxTranslate.COLOR.t() + ": "), (int)8, (int)80, (int)0);
            FontHelper.text((String)(TextFormatting.RED + FluxTranslate.COLOUR_RED_CHAR.t() + ":"), (int)46, (int)80, (int)-1);
            FontHelper.text((String)(TextFormatting.GREEN + FluxTranslate.COLOUR_GREEN_CHAR.t() + ":"), (int)86, (int)80, (int)-1);
            FontHelper.text((String)(TextFormatting.BLUE + FluxTranslate.COLOUR_BLUE_CHAR.t() + ":"), (int)126, (int)80, (int)-1);
            CustomColour colour = this.getCurrentColour();
            Gui.func_73734_a((int)55, (int)95, (int)165, (int)104, (int)colour.getRGB());
            FontHelper.text((String)(FluxTranslate.ACCESS_SETTING.t() + ": " + TextFormatting.AQUA + this.currentAccess.getDisplayName()), (int)8, (int)40, (int)0);
            FontHelper.text((String)(FluxTranslate.ALLOW_CONVERSION.t() + ": " + TextFormatting.AQUA + FluxTranslate.translateBoolean(this.enableConversion)), (int)8, (int)52, (int)0);
            FontHelper.text((String)(FluxTranslate.ENERGY_TYPE.t() + ": " + TextFormatting.AQUA + this.type.getName()), (int)8, (int)64, (int)0);
            FontHelper.text((String)(FluxTranslate.PREVIEW.t() + ": "), (int)8, (int)96, (int)0);
            String networkName = this.name.func_146179_b().isEmpty() ? FluxTranslate.NETWORK_NAME.t() : this.name.func_146179_b();
            this.renderNetwork(networkName, this.currentAccess, colour.getRGB(), this.previewSelected, 11, 116);
            if (x - this.getGuiLeft() > 55 && x - this.getGuiLeft() < 165 && y - this.getGuiTop() > 95 && y - this.getGuiTop() < 104) {
                this.func_146279_a(FluxTranslate.NEXT_COLOUR.t(), x - this.getGuiLeft(), y - this.getGuiTop());
            }
            if (x - this.getGuiLeft() > 5 && x - this.getGuiLeft() < 165 && y - this.getGuiTop() > 38 && y - this.getGuiTop() < 52) {
                this.func_146279_a(FluxTranslate.CHANGE_SETTING.t(), x - this.getGuiLeft(), y - this.getGuiTop());
            }
            if (x - this.getGuiLeft() > 5 && x - this.getGuiLeft() < 165 && y - this.getGuiTop() > 50 && y - this.getGuiTop() < 64) {
                this.func_146279_a(FluxTranslate.ALLOW_CONVERSION.t() + ": " + FluxTranslate.translateBoolean(this.enableConversion), x - this.getGuiLeft(), y - this.getGuiTop());
            }
            if (x - this.getGuiLeft() > 5 && x - this.getGuiLeft() < 165 && y - this.getGuiTop() > 62 && y - this.getGuiTop() < 76) {
                this.func_146279_a(FluxTranslate.ENERGY_TYPE.t() + ": " + this.type.getName(), x - this.getGuiLeft(), y - this.getGuiTop());
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 5: {
                this.resetCreateTab();
                break;
            }
            case 6: {
                if (this.name.func_146179_b().isEmpty()) break;
                if (this.getCurrentTab() == EnumGuiTab.NETWORK_CREATE) {
                    PacketGeneralHelper.sendPacketToServer(PacketGeneralType.CREATE_NETWORK, PacketGeneralHelper.createNetworkCreationPacket(this.name.func_146179_b(), this.getCurrentColour(), this.currentAccess, this.enableConversion, this.type));
                } else {
                    PacketGeneralHelper.sendPacketToServer(PacketGeneralType.EDIT_NETWORK, PacketGeneralHelper.createNetworkEditPacket(this.getNetworkID(), this.name.func_146179_b(), this.getCurrentColour(), this.currentAccess, this.enableConversion, this.type));
                }
                this.switchTab(EnumGuiTab.NETWORK_SELECTION);
                this.resetCreateTab();
                return;
            }
        }
    }

    public void func_73864_a(int x, int y, int mouseButton) throws IOException {
        super.func_73864_a(x, y, mouseButton);
        if (mouseButton == 1 && this.name.func_146206_l()) {
            this.name.func_146180_a("");
        }
        if (x - this.getGuiLeft() > 55 && x - this.getGuiLeft() < 165 && y - this.getGuiTop() > 95 && y - this.getGuiTop() < 104) {
            ++this.currentColour;
            if (this.currentColour >= GuiTabAbstract.colours.length) {
                this.currentColour = 0;
            }
            CustomColour colour = GuiTabAbstract.colours[this.currentColour];
            this.r.func_146180_a(String.valueOf(colour.red));
            this.g.func_146180_a(String.valueOf(colour.green));
            this.b.func_146180_a(String.valueOf(colour.blue));
        }
        if (x - this.getGuiLeft() > 5 && x - this.getGuiLeft() < 165 && y - this.getGuiTop() > 38 && y - this.getGuiTop() < 52) {
            this.currentAccess = AccessType.values()[this.currentAccess.ordinal() + 1 < AccessType.values().length ? this.currentAccess.ordinal() + 1 : 0];
        }
        if (x - this.getGuiLeft() > 5 && x - this.getGuiLeft() < 165 && y - this.getGuiTop() > 50 && y - this.getGuiTop() < 64) {
            boolean bl = this.enableConversion = !this.enableConversion;
        }
        if (x - this.getGuiLeft() > 11 && x - this.getGuiLeft() < 165 && y - this.getGuiTop() > 108 && y - this.getGuiTop() < 134) {
            boolean bl = this.showFullPreview = !this.showFullPreview;
        }
        if (x - this.getGuiLeft() > 5 && x - this.getGuiLeft() < 165 && y - this.getGuiTop() > 62 && y - this.getGuiTop() < 76) {
            this.type = (EnergyType)SonarHelper.incrementEnum((Enum)this.type, (Enum[])EnergyType.values());
        }
    }

    public void resetCreateTab() {
        this.name.func_146180_a("");
        this.currentColour = 0;
        this.currentAccess = AccessType.PRIVATE;
        this.reset();
    }

    public void initEditFields(String networkName, CustomColour colour) {
        this.name = new SonarTextField(1, this.getFontRenderer(), 38, 22, 130, 12).setBoxOutlineColour(Color.DARK_GRAY.getRGB());
        this.name.func_146203_f(24);
        this.name.func_146180_a(networkName);
        this.r = new SonarTextField(2, this.getFontRenderer(), 56, 78, 28, 12).setBoxOutlineColour(Color.DARK_GRAY.getRGB()).setDigitsOnly(true);
        this.r.func_146203_f(3);
        this.r.func_146180_a(String.valueOf(colour.red));
        this.g = new SonarTextField(3, this.getFontRenderer(), 96, 78, 28, 12).setBoxOutlineColour(Color.DARK_GRAY.getRGB()).setDigitsOnly(true);
        this.g.func_146203_f(3);
        this.g.func_146180_a(String.valueOf(colour.green));
        this.b = new SonarTextField(4, this.getFontRenderer(), 136, 78, 28, 12).setBoxOutlineColour(Color.DARK_GRAY.getRGB()).setDigitsOnly(true);
        this.b.func_146203_f(3);
        this.b.func_146180_a(String.valueOf(colour.blue));
        this.fieldList.addAll(Lists.newArrayList((Object[])new SonarTextField[]{this.name, this.r, this.g, this.b}));
    }

    public CustomColour getCurrentColour() {
        return new CustomColour(this.r.getIntegerFromText(), this.g.getIntegerFromText(), this.b.getIntegerFromText());
    }

    public ResourceLocation getBackground() {
        return blank_flux_gui;
    }

    @Override
    public EnumGuiTab getCurrentTab() {
        return EnumGuiTab.NETWORK_EDIT;
    }
}

