/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.util;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentString;
import xt9.deepmoblearning.common.Registry;
import xt9.deepmoblearning.common.capabilities.IPlayerTrial;
import xt9.deepmoblearning.common.capabilities.PlayerTrialProvider;
import xt9.deepmoblearning.common.items.ItemDataModel;
import xt9.deepmoblearning.common.items.ItemGlitchSword;
import xt9.deepmoblearning.common.mobmetas.MobMetaData;
import xt9.deepmoblearning.common.mobmetas.MobMetaFactory;
import xt9.deepmoblearning.common.util.DataModelExperience;
import xt9.deepmoblearning.common.util.ItemStackNBTHelper;
import xt9.deepmoblearning.common.util.PlayerHelper;
import xt9.deepmoblearning.common.util.Tier;

public class DataModel {
    public static NonNullList<ItemStack> getValidFromList(NonNullList<ItemStack> list) {
        NonNullList filteredList = NonNullList.func_191196_a();
        for (ItemStack stack : list) {
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemDataModel)) continue;
            filteredList.add((Object)stack);
        }
        return filteredList;
    }

    public static ItemStack getModelFromMobKey(String mobKey) {
        ItemStack result = ItemStack.field_190927_a;
        for (ItemDataModel dataModel : Registry.dataModels) {
            if (!dataModel.getMobKey().equals(mobKey)) continue;
            result = new ItemStack((Item)dataModel);
        }
        return result;
    }

    public static boolean hasExtraTooltip(ItemStack stack) {
        return DataModel.getExtraTooltip(stack) != null;
    }

    public static String getExtraTooltip(ItemStack stack) {
        return DataModel.getMobMetaData(stack).getExtraTooltip();
    }

    public static String getMatterTypeName(ItemStack stack) {
        return DataModel.getMobMetaData(stack).getMatterTypeName();
    }

    public static int getSimulationTickCost(ItemStack stack) {
        return DataModel.getMobMetaData(stack).getSimulationTickCost();
    }

    public static String getMobKey(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemDataModel) {
            return ((ItemDataModel)stack.func_77973_b()).getMobKey();
        }
        return "zombie";
    }

    public static MobMetaData getMobMetaData(ItemStack stack) {
        return MobMetaFactory.createMobMetaData(DataModel.getMobKey(stack));
    }

    public static int getPristineChance(ItemStack stack) {
        return Tier.getPristineChance(DataModel.getTier(stack));
    }

    public static String getTierName(ItemStack stack, boolean getNextTierName) {
        return Tier.getTierName(DataModel.getTier(stack), getNextTierName);
    }

    public static void increaseMobKillCount(ItemStack stack, EntityPlayerMP player) {
        int tier = DataModel.getTier(stack);
        int i = DataModel.getCurrentTierKillCount(stack);
        boolean isGlitchSwordEquipped = player.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemGlitchSword;
        IPlayerTrial cap = (IPlayerTrial)player.getCapability(PlayerTrialProvider.PLAYER_TRIAL_CAP, null);
        DataModel.setCurrentTierKillCount(stack, i += isGlitchSwordEquipped && !cap.isTrialActive() ? 2 : 1);
        DataModel.setTotalKillCount(stack, DataModel.getTotalKillCount(stack) + 1);
        if (DataModelExperience.shouldIncreaseTier(tier, i, DataModel.getCurrentTierSimulationCount(stack))) {
            PlayerHelper.sendMessage(player, new TextComponentString(stack.func_82833_r() + " reached the " + DataModel.getTierName(stack, true) + " tier"));
            DataModel.setCurrentTierKillCount(stack, 0);
            DataModel.setCurrentTierSimulationCount(stack, 0);
            DataModel.setTier(stack, tier + 1);
        }
    }

    public static void increaseSimulationCount(ItemStack stack) {
        int tier = DataModel.getTier(stack);
        int i = DataModel.getCurrentTierSimulationCount(stack);
        DataModel.setCurrentTierSimulationCount(stack, ++i);
        DataModel.setTotalSimulationCount(stack, DataModel.getTotalSimulationCount(stack) + 1);
        if (DataModelExperience.shouldIncreaseTier(tier, DataModel.getCurrentTierKillCount(stack), i)) {
            DataModel.setCurrentTierKillCount(stack, 0);
            DataModel.setCurrentTierSimulationCount(stack, 0);
            DataModel.setTier(stack, tier + 1);
        }
    }

    public static int getTier(ItemStack stack) {
        return ItemStackNBTHelper.getInt(stack, "tier", 0);
    }

    public static void setTier(ItemStack stack, int tier) {
        ItemStackNBTHelper.setInt(stack, "tier", tier);
    }

    public static int getCurrentTierKillCount(ItemStack stack) {
        return ItemStackNBTHelper.getInt(stack, "killCount", 0);
    }

    public static void setCurrentTierKillCount(ItemStack stack, int count) {
        ItemStackNBTHelper.setInt(stack, "killCount", count);
    }

    public static int getCurrentTierSimulationCount(ItemStack stack) {
        return ItemStackNBTHelper.getInt(stack, "simulationCount", 0);
    }

    public static void setCurrentTierSimulationCount(ItemStack stack, int count) {
        ItemStackNBTHelper.setInt(stack, "simulationCount", count);
    }

    public static int getTotalKillCount(ItemStack stack) {
        return ItemStackNBTHelper.getInt(stack, "totalKillCount", 0);
    }

    public static void setTotalKillCount(ItemStack stack, int count) {
        ItemStackNBTHelper.setInt(stack, "totalKillCount", count);
    }

    public static int getTotalSimulationCount(ItemStack stack) {
        return ItemStackNBTHelper.getInt(stack, "totalSimulationCount", 0);
    }

    public static void setTotalSimulationCount(ItemStack stack, int count) {
        ItemStackNBTHelper.setInt(stack, "totalSimulationCount", count);
    }

    public static double getCurrentTierKillCountWithSims(ItemStack stack) {
        return DataModelExperience.getCurrentTierKillCountWithSims(DataModel.getTier(stack), DataModel.getCurrentTierKillCount(stack), DataModel.getCurrentTierSimulationCount(stack));
    }

    public static int getCurrentTierSimulationCountWithKills(ItemStack stack) {
        return DataModelExperience.getCurrentTierSimulationCountWithKills(DataModel.getTier(stack), DataModel.getCurrentTierKillCount(stack), DataModel.getCurrentTierSimulationCount(stack));
    }

    public static double getKillsToNextTier(ItemStack stack) {
        return DataModelExperience.getKillsToNextTier(DataModel.getTier(stack), DataModel.getCurrentTierKillCount(stack), DataModel.getCurrentTierSimulationCount(stack));
    }

    public static int getSimulationsToNextTier(ItemStack stack) {
        return DataModelExperience.getSimulationsToNextTier(DataModel.getTier(stack), DataModel.getCurrentTierKillCount(stack), DataModel.getCurrentTierSimulationCount(stack));
    }

    public static int getTierRoofAsKills(ItemStack stack) {
        if (DataModel.getTier(stack) == 4) {
            return 0;
        }
        return DataModelExperience.getTierRoof(DataModel.getTier(stack), true);
    }

    public static int getTierRoof(ItemStack stack) {
        if (DataModel.getTier(stack) == 4) {
            return 0;
        }
        return DataModelExperience.getTierRoof(DataModel.getTier(stack), false);
    }
}

