/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.ChannelModeCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ClientLinked;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Mask;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public interface ModeInfo
extends ClientLinked {
    @Nonnull
    public Optional<String> getCreator();

    @Nonnull
    public Channel getChannel();

    @Nonnull
    public Mask getMask();

    @Nonnull
    public ChannelMode getMode();

    @Nonnull
    public Optional<Instant> getCreationTime();

    default public void remove() {
        new ChannelModeCommand(this.getClient(), this.getChannel().getName()).add(false, this.getMode(), this.getMask().asString()).execute();
    }

    public static class DefaultModeInfo
    implements ModeInfo {
        private final Client client;
        private final Instant creationTime;
        private final String creator;
        private final Channel channel;
        private final Mask mask;
        private final ChannelMode mode;

        public DefaultModeInfo(@Nonnull Client client, @Nonnull Channel channel, @Nonnull ChannelMode mode, @Nonnull String mask, @Nullable String creator, @Nullable Instant creationTime) {
            this.client = client;
            this.creator = creator;
            this.channel = channel;
            this.mask = Mask.fromString(mask);
            this.creationTime = creationTime;
            this.mode = mode;
        }

        @Override
        @Nonnull
        public Optional<String> getCreator() {
            return Optional.ofNullable(this.creator);
        }

        @Override
        @Nonnull
        public Channel getChannel() {
            return this.channel;
        }

        @Override
        @Nonnull
        public Client getClient() {
            return this.client;
        }

        @Override
        @Nonnull
        public Mask getMask() {
            return this.mask;
        }

        @Override
        @Nonnull
        public ChannelMode getMode() {
            return this.mode;
        }

        @Override
        @Nonnull
        public Optional<Instant> getCreationTime() {
            return Optional.ofNullable(this.creationTime);
        }

        @Nonnull
        public String toString() {
            return new ToStringer(this).add("client", this.client).add("channel", this.channel).add("mode", this.mode).add("mask", this.mask).add("creator", this.creator).add("creationTime", this.creationTime).toString();
        }
    }
}

