/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.ChannelCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageType;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class KickCommand
extends ChannelCommand {
    private String target;
    @Nullable
    private String reason = this.getClient().getDefaultMessageMap().getDefault(DefaultMessageType.KICK).orElse(null);

    public KickCommand(@Nonnull Client client, @Nonnull String channel) {
        super(client, channel);
    }

    @Nonnull
    public KickCommand target(@Nonnull String target) {
        this.target = Sanity.safeMessageCheck(target, "Target");
        return this;
    }

    @Nonnull
    public KickCommand target(@Nonnull User target) {
        Sanity.nullCheck(target, "Target cannot be null");
        Sanity.truthiness(target.getClient() == this.getClient(), "User comes from a different client");
        this.target(target.getNick());
        return this;
    }

    @Nonnull
    public KickCommand reason(@Nullable String reason) {
        this.reason = reason == null ? null : Sanity.safeMessageCheck(reason, "Reason");
        return this;
    }

    @Override
    public void execute() {
        if (this.target == null) {
            throw new IllegalStateException("Target not defined");
        }
        this.getClient().sendRawLine("KICK " + this.getChannel() + ' ' + this.target + (this.reason != null ? " :" + this.reason : ""));
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("target", this.target).add("reason", this.reason);
    }
}

