/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.plugin.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.tcomplement.TinkersComplement;
import knightminer.tcomplement.common.Config;
import knightminer.tcomplement.melter.MelterModule;
import knightminer.tcomplement.melter.client.GuiMelter;
import knightminer.tcomplement.plugin.chisel.ChiselPlugin;
import knightminer.tcomplement.plugin.exnihilo.ExNihiloPlugin;
import knightminer.tcomplement.plugin.jei.melter.MeltingRecipeCategory;
import knightminer.tcomplement.plugin.jei.melter.MeltingRecipeChecker;
import knightminer.tcomplement.plugin.jei.melter.MeltingRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.smeltery.client.IGuiLiquidTank;
import slimeknights.tconstruct.tools.TinkerMaterials;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    private static final String FURNACE_FUEL = "minecraft.fuel";
    private static final String TINKERS_SMELTERY = "tconstruct.smeltery";
    private static final String TINKERS_ALLOYING = "tconstruct.alloy";
    private static final String EXNIHILO_HAMMER = "exnihilocreatio:hammer";
    private static final String CHISEL_CHISELING = "chisel.chiseling";
    public static MeltingRecipeCategory meltingCategory;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        if (Config.jei.separateMelterTab && TinkersComplement.pulseManager.isPulseLoaded("ModuleMelter")) {
            IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
            meltingCategory = new MeltingRecipeCategory(guiHelper);
            iRecipeCategoryArray[0] = meltingCategory;
            registry.addRecipeCategories(iRecipeCategoryArray);
        }
    }

    public void register(IModRegistry registry) {
        if (TinkersComplement.pulseManager.isPulseLoaded("ModuleMelter")) {
            String melterCategory = TINKERS_SMELTERY;
            if (Config.jei.separateMelterTab) {
                melterCategory = MeltingRecipeCategory.CATEGORY;
                registry.handleRecipes(MeltingRecipe.class, MeltingRecipeWrapper::new, MeltingRecipeCategory.CATEGORY);
                registry.addRecipes(MeltingRecipeChecker.getMeltingRecipes(), MeltingRecipeCategory.CATEGORY);
            }
            if (MelterModule.melter != null) {
                registry.addRecipeCatalyst((Object)new ItemStack((Block)MelterModule.melter), new String[]{melterCategory});
                registry.addRecipeCatalyst((Object)new ItemStack((Block)MelterModule.melter, 1, 8), new String[]{FURNACE_FUEL});
            }
            if (MelterModule.porcelainMelter != null) {
                registry.addRecipeCatalyst((Object)new ItemStack((Block)MelterModule.porcelainMelter), new String[]{melterCategory});
                registry.addRecipeCatalyst((Object)new ItemStack((Block)MelterModule.porcelainMelter, 1, 8), new String[]{FURNACE_FUEL});
            }
            if (MelterModule.alloyTank != null) {
                registry.addRecipeCatalyst((Object)new ItemStack(MelterModule.alloyTank), new String[]{TINKERS_ALLOYING});
            }
            if (MelterModule.porcelainAlloyTank != null) {
                registry.addRecipeCatalyst((Object)new ItemStack(MelterModule.porcelainAlloyTank), new String[]{TINKERS_ALLOYING});
            }
            registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TinkerGuiTankHandler<GuiMelter>(GuiMelter.class)});
        }
        if (ChiselPlugin.chisel != null) {
            registry.addRecipeCatalyst((Object)ChiselPlugin.chisel.buildItem((List)ImmutableList.of((Object)TinkerMaterials.wood, (Object)TinkerMaterials.iron)), new String[]{CHISEL_CHISELING});
        }
        if (ExNihiloPlugin.sledgeHammer != null) {
            registry.addRecipeCatalyst((Object)ExNihiloPlugin.sledgeHammer.buildItem((List)ImmutableList.of((Object)TinkerMaterials.wood, (Object)TinkerMaterials.iron, (Object)TinkerMaterials.paper)), new String[]{EXNIHILO_HAMMER});
        }
    }

    private static class TinkerGuiTankHandler<T extends GuiContainer>
    implements IAdvancedGuiHandler<T> {
        private Class<T> clazz;

        public TinkerGuiTankHandler(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Nonnull
        public Class<T> getGuiContainerClass() {
            return this.clazz;
        }

        @Nullable
        public Object getIngredientUnderMouse(T guiContainer, int mouseX, int mouseY) {
            return ((IGuiLiquidTank)guiContainer).getFluidStackAtPosition(mouseX, mouseY);
        }
    }
}

