/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.melter.tileentity;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.tcomplement.TinkersComplement;
import knightminer.tcomplement.library.IHeaterConsumer;
import knightminer.tcomplement.library.tanks.AlloyTank;
import knightminer.tcomplement.library.tanks.FluidHandlerDrainOnlyWrapper;
import knightminer.tcomplement.melter.blocks.BlockAlloyTank;
import knightminer.tcomplement.melter.tileentity.TileHeater;
import knightminer.tcomplement.melter.tileentity.TileMelter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.utils.FluidUtil;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public class TileAlloyTank
extends TileTank
implements ITickable,
IHeaterConsumer {
    protected static final int ALLOYING_PER_TICK = 10;
    protected int tick = 0;
    private boolean active;
    private boolean needsFuel;
    private int fuel;
    private int fuelQuality;
    private List<BlockPos> tanks = Lists.newLinkedList();
    private AlloyTank alloyTank;
    private IFluidHandler tankWrapper = new FluidHandlerDrainOnlyWrapper((IFluidHandler)this.tank);
    private AlloyRecipe currentRecipe;
    private static final String TAG_FUEL = "fuel";
    private static final String TAG_FUEL_QUALITY = "fuel_quality";
    private static final String TAG_NEEDS_FUEL = "needs_fuel";
    private static final String TAG_TANKS = "tanks";
    private static final String TAG_ACTIVE = "active";

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.active) {
            return;
        }
        if (this.tick % 4 == 0) {
            List<FluidStack> inputs;
            AlloyTank alloyTank;
            if (this.needsFuel) {
                this.consumeFuel();
            }
            if (this.tank.getFluidAmount() != 4000 && (alloyTank = this.getAlloyTank()) != null && (inputs = alloyTank.getFluids()).size() >= 2) {
                FluidStack current = this.tank.getFluid();
                if (this.currentRecipe == null || !this.tryRecipe(this.currentRecipe, current, inputs, alloyTank)) {
                    this.currentRecipe = null;
                    for (AlloyRecipe recipe : TinkerRegistry.getAlloys()) {
                        if (!this.tryRecipe(recipe, current, inputs, alloyTank)) continue;
                        this.currentRecipe = recipe;
                        break;
                    }
                }
            }
        }
        this.tick = (this.tick + 1) % 20;
    }

    private boolean tryRecipe(AlloyRecipe recipe, @Nullable FluidStack current, @Nonnull List<FluidStack> inputs, @Nonnull AlloyTank alloyTank) {
        int filled;
        int remaining;
        if (!recipe.isValid()) {
            return false;
        }
        FluidStack result = FluidUtil.getValidFluidStackOrNull((FluidStack)recipe.getResult());
        if (result == null || current != null && !result.isFluidEqual(current)) {
            return false;
        }
        int matched = recipe.matches(inputs);
        if (matched <= 0) {
            return false;
        }
        int n = remaining = current == null ? 4000 : 4000 - current.amount;
        if (remaining < result.amount) {
            return true;
        }
        if (!this.hasFuel()) {
            this.needsFuel = true;
            return true;
        }
        matched = Math.min(matched * result.amount, Math.min(10, remaining));
        do {
            for (FluidStack liquid : recipe.getFluids()) {
                FluidStack toDrain = liquid.copy();
                FluidStack drained = alloyTank.drain(toDrain, true);
                assert (drained != null);
                if (drained.isFluidEqual(toDrain) && drained.amount == toDrain.amount) continue;
                TinkersComplement.log.error("Melter alloy creation drained incorrect amount: was {}:{}, should be {}:{}", (Object)drained.getUnlocalizedName(), (Object)drained.amount, (Object)toDrain.getUnlocalizedName(), (Object)toDrain.amount);
            }
            FluidStack toFill = result.copy();
            filled = this.tank.fill(toFill, true);
            if (filled == result.amount) continue;
            TinkersComplement.log.error("Melter alloy creation filled incorrect amount: was {}, should be {} ({})", (Object)filled, (Object)(recipe.getResult().amount * matched), (Object)result.getUnlocalizedName());
        } while ((matched -= filled) > 0);
        --this.fuel;
        return true;
    }

    private void consumeFuel() {
        if (this.hasFuel()) {
            this.needsFuel = false;
            return;
        }
        World world = this.func_145831_w();
        if (world == null) {
            return;
        }
        TileEntity te = world.func_175625_s(this.field_174879_c.func_177977_b());
        if (te instanceof TileHeater) {
            int time = ((TileHeater)te).consumeFuel();
            if (time > 0) {
                this.fuel += time;
                this.fuelQuality = time;
                this.needsFuel = false;
            } else {
                this.fuelQuality = 0;
            }
        }
    }

    private AlloyTank getAlloyTank() {
        if (!this.active) {
            return null;
        }
        if (this.alloyTank != null) {
            return this.alloyTank;
        }
        LinkedList newTanks = Lists.newLinkedList();
        for (BlockPos pos : this.tanks) {
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            if (te instanceof TileTank) {
                newTanks.add(((TileTank)te).getInternalTank());
                continue;
            }
            if (!(te instanceof TileMelter)) continue;
            newTanks.add(((TileMelter)te).getTank());
        }
        if (!newTanks.isEmpty()) {
            this.alloyTank = new AlloyTank(newTanks);
        }
        return this.alloyTank;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankWrapper);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void checkTanks() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if ((this.func_145832_p() & 8) > 0) {
            this.active = false;
            this.tanks.clear();
            this.alloyTank = null;
            return;
        }
        if (!(this.func_145838_q() instanceof BlockAlloyTank)) {
            return;
        }
        BlockAlloyTank tankBlock = (BlockAlloyTank)this.field_145854_h;
        this.tanks.clear();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos offset;
            IBlockState state;
            if (side == EnumFacing.DOWN || !tankBlock.isTank(state = this.field_145850_b.func_180495_p(offset = this.field_174879_c.func_177972_a(side)))) continue;
            this.tanks.add(offset);
        }
        this.alloyTank = null;
        this.active = tankBlock.isHeater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()));
    }

    @Override
    public boolean hasFuel() {
        return this.fuel > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getFuelPercentage() {
        return (float)this.fuel / (float)this.fuelQuality;
    }

    @Override
    public int getFuel() {
        return this.fuel;
    }

    @Override
    public int getFuelQuality() {
        return this.fuelQuality;
    }

    @Override
    public void updateFuelFromPacket(int index, int fuel) {
        if (index == 0) {
            this.fuel = fuel;
        } else if (index == 1) {
            this.fuelQuality = fuel;
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        tags.func_74757_a(TAG_ACTIVE, this.active);
        tags.func_74757_a(TAG_NEEDS_FUEL, this.needsFuel);
        tags.func_74768_a(TAG_FUEL, this.fuel);
        tags.func_74768_a(TAG_FUEL_QUALITY, this.fuelQuality);
        NBTTagList tankList = new NBTTagList();
        for (BlockPos pos : this.tanks) {
            tankList.func_74742_a((NBTBase)TagUtil.writePos((BlockPos)pos));
        }
        tags.func_74782_a(TAG_TANKS, (NBTBase)tankList);
        return tags;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.active = tags.func_74767_n(TAG_ACTIVE);
        this.needsFuel = tags.func_74767_n(TAG_NEEDS_FUEL);
        this.fuel = tags.func_74762_e(TAG_FUEL);
        this.fuelQuality = tags.func_74762_e(TAG_FUEL_QUALITY);
        NBTTagList tankList = tags.func_150295_c(TAG_TANKS, 10);
        this.tanks.clear();
        for (int i = 0; i < tankList.func_74745_c(); ++i) {
            this.tanks.add(TagUtil.readPos((NBTTagCompound)tankList.func_150305_b(i)));
        }
    }
}

