/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.melter.blocks;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import knightminer.tcomplement.TinkersComplement;
import knightminer.tcomplement.library.IHeaterConsumer;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.melter.tileentity.TileHeater;
import knightminer.tcomplement.melter.tileentity.TileMelter;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.smeltery.block.BlockMultiblockController;
import slimeknights.tconstruct.smeltery.block.BlockTank;
import slimeknights.tconstruct.smeltery.tileentity.TileMultiblock;

public class BlockMelter
extends BlockMultiblockController {
    public static final PropertyEnum<MelterType> TYPE = PropertyEnum.func_177709_a((String)"type", MelterType.class);
    private BlockTank melterTank;

    public BlockMelter(BlockTank melterTank) {
        super(Material.field_151576_e);
        this.func_149647_a((CreativeTabs)TCompRegistry.tabGeneral);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.melterTank = melterTank;
    }

    public BlockTank getMelterTank() {
        return this.melterTank;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this.func_176203_a(meta).func_177229_b(TYPE) == MelterType.HEATER) {
            return new TileHeater();
        }
        return new TileMelter();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileMultiblock te = this.getTile((IBlockAccess)worldIn, pos);
        if (te != null) {
            te.checkMultiblockStructure();
        }
    }

    protected boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177229_b(TYPE) == MelterType.MELTER && !this.isActive((IBlockAccess)world, pos)) {
            return false;
        }
        player.openGui((Object)TinkersComplement.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING, ACTIVE});
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) != null) {
            return state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(this.isActive(world, pos)));
        }
        return state;
    }

    public boolean isActive(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177229_b(TYPE) == MelterType.HEATER) {
            TileEntity te = world.func_175625_s(pos.func_177984_a());
            return te instanceof IHeaterConsumer;
        }
        return super.isActive(world, pos);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(meta & 7));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        MelterType type = MelterType.fromMeta(meta >> 3);
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)).func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + (((MelterType)((Object)state.func_177229_b(TYPE))).getMeta() << 3);
    }

    public int func_180651_a(IBlockState state) {
        return ((MelterType)((Object)state.func_177229_b(TYPE))).getMeta() << 3;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 8));
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isActive((IBlockAccess)world, pos)) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + (double)(rand.nextFloat() * 6.0f / 16.0f);
            double z = (double)pos.func_177952_p() + 0.5;
            double frontOffset = 0.52;
            double sideOffset = rand.nextDouble() * 0.6 - 0.3;
            this.spawnFireParticles(world, enumfacing, x, y, z, frontOffset, sideOffset);
        }
    }

    public static enum MelterType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        MELTER,
        HEATER;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }

        public static MelterType fromMeta(int meta) {
            if (meta < 0 || meta >= MelterType.values().length) {
                meta = 0;
            }
            return MelterType.values()[meta];
        }
    }
}

