/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.jei.ingredients;

import java.util.ArrayList;
import modulardiversity.jei.IFakeIngredient;

public class DaylightIngredient
implements IFakeIngredient {
    private ArrayList<Integer> daylight;

    public DaylightIngredient(ArrayList<Integer> daylight) {
        this.daylight = daylight;
    }

    public String getClockCfg(int index) {
        int num = (int)Math.floor((this.daylight.get(index) - 6000) / 375);
        if (num < 0) {
            num += 64;
        }
        String numString = Integer.toString(num);
        if (num < 10) {
            numString = "0" + numString;
        }
        return numString;
    }

    public int getDaylight(int index) {
        return this.daylight.get(index);
    }

    public static String getFormattedTime(long time) {
        boolean am = true;
        double cfg = time;
        if ((cfg += 6000.0) > 23999.0) {
            cfg -= 24000.0;
        }
        if (cfg >= 12000.0) {
            am = false;
            cfg -= 12000.0;
        }
        if ((cfg = Math.floor(cfg / 10.0) / 100.0) > 12.0) {
            cfg -= 12.0;
        }
        int cfgi = (int)Math.floor(cfg);
        int cfgj = (int)Math.floor((cfg - (double)cfgi) * 60.0);
        return Integer.toString(cfgi) + (cfgj < 10 ? ":0" : ":") + Integer.toString(cfgj) + (am ? " a.m." : " p.m.");
    }

    @Override
    public String getDisplayName() {
        return "Time Required: Between " + DaylightIngredient.getFormattedTime(this.daylight.get(0).intValue()) + " : " + DaylightIngredient.getFormattedTime(this.daylight.get(1).intValue());
    }

    @Override
    public String getUniqueID() {
        return "daylight";
    }
}

