/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumePerTick;
import modulardiversity.jei.JEIComponentMechanical;
import modulardiversity.jei.ingredients.Mechanical;
import modulardiversity.util.IResourceToken;

public class RequirementMechanical
extends RequirementConsumePerTick<Mechanical, ResourceToken> {
    public final int requiredLevel;
    public final boolean isCrankAllowed;

    public RequirementMechanical(MachineComponent.IOType ioType, int requiredLevel, boolean isCrankAllowed) {
        super(ComponentType.Registry.getComponent((String)"mechanical"), ioType);
        this.requiredLevel = requiredLevel;
        this.isCrankAllowed = isCrankAllowed;
    }

    public ComponentRequirement deepCopy() {
        return new RequirementMechanical(this.getActionType(), this.requiredLevel, this.isCrankAllowed);
    }

    public ComponentRequirement.JEIComponent<Mechanical> provideJEIComponent() {
        return new JEIComponentMechanical(this);
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.requiredLevel, this.isCrankAllowed);
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("mechanical") && component instanceof MachineComponents.MechanicalHatch && component.getIOType() == this.getActionType();
    }

    public static class ResourceToken
    implements IResourceToken {
        private int requiredLevel;
        private boolean isCrankAllowed;
        private boolean requiredlevelMet;

        public ResourceToken(int requiredLevel, boolean isCrankAllowed) {
            this.requiredLevel = requiredLevel;
            this.isCrankAllowed = isCrankAllowed;
        }

        public int getRequiredLevel() {
            return this.requiredLevel;
        }

        public boolean isCrankAllowed() {
            return this.isCrankAllowed;
        }

        public void setRequiredlevelMet() {
            this.requiredlevelMet = true;
        }

        @Override
        public float getModifier() {
            return this.requiredLevel;
        }

        @Override
        public void setModifier(float modifier) {
            this.requiredLevel = (int)modifier;
        }

        @Override
        public boolean isEmpty() {
            return this.requiredlevelMet;
        }
    }
}

