/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.item.ItemBlockMachineComponent;
import hellfirepvp.modularmachinery.common.item.ItemBlockMachineComponentCustomName;
import java.util.ArrayList;
import modulardiversity.ModularDiversity;
import modulardiversity.block.BlockBiomeDetector;
import modulardiversity.block.BlockDaylightDetector;
import modulardiversity.block.BlockEmberInputHatch;
import modulardiversity.block.BlockEmberOutputHatch;
import modulardiversity.block.BlockHotAirInputHatch;
import modulardiversity.block.BlockHotAirOutputHatch;
import modulardiversity.block.BlockJackHatch;
import modulardiversity.block.BlockLaserHatch;
import modulardiversity.block.BlockManaInputHatch;
import modulardiversity.block.BlockManaOutputHatch;
import modulardiversity.block.BlockMechCrankHatch;
import modulardiversity.block.BlockMechInputHatch;
import modulardiversity.block.BlockMechOutputHatch;
import modulardiversity.block.BlockMekHeatInput;
import modulardiversity.block.BlockMekHeatOutput;
import modulardiversity.block.BlockMekLaserAcceptor;
import modulardiversity.block.BlockMysticalMechanicsInput;
import modulardiversity.block.BlockMysticalMechanicsOutput;
import modulardiversity.block.BlockWeatherDetector;
import modulardiversity.components.ComponentBiome;
import modulardiversity.components.ComponentDaylight;
import modulardiversity.components.ComponentEmber;
import modulardiversity.components.ComponentHotAir;
import modulardiversity.components.ComponentLaser;
import modulardiversity.components.ComponentMana;
import modulardiversity.components.ComponentMechanical;
import modulardiversity.components.ComponentMekHeat;
import modulardiversity.components.ComponentMekLaser;
import modulardiversity.components.ComponentMysticalMechanics;
import modulardiversity.components.ComponentWeather;
import modulardiversity.tile.TileEmberInputHatch;
import modulardiversity.tile.TileEmberOutputHatch;
import modulardiversity.tile.TileEntityBiomeDetector;
import modulardiversity.tile.TileEntityDaylightDetector;
import modulardiversity.tile.TileEntityMekHeatInput;
import modulardiversity.tile.TileEntityMekHeatOutput;
import modulardiversity.tile.TileEntityMekLaserAcceptor;
import modulardiversity.tile.TileEntityWeatherDetector;
import modulardiversity.tile.TileHotAirInput;
import modulardiversity.tile.TileHotAirOutput;
import modulardiversity.tile.TileJackHatch;
import modulardiversity.tile.TileLaserInput;
import modulardiversity.tile.TileManaInputHatch;
import modulardiversity.tile.TileManaOutputHatch;
import modulardiversity.tile.TileMechInput;
import modulardiversity.tile.TileMechInputCrank;
import modulardiversity.tile.TileMechOutput;
import modulardiversity.tile.TileMysticalMechanicsInput;
import modulardiversity.tile.TileMysticalMechanicsOutput;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class Registry {
    private static ArrayList<Block> BLOCKS = new ArrayList();
    private static ArrayList<Item> ITEMS = new ArrayList();

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register(Registry.class);
        Registry.registerBlocks();
        Registry.registerTileEntities();
    }

    public static void registerBlocks() {
        if (ModularDiversity.EmbersLoaded) {
            BlockEmberInputHatch emberInputHatch = new BlockEmberInputHatch();
            BlockEmberOutputHatch emberOutputHatch = new BlockEmberOutputHatch();
            Registry.registerBlock("blockemberinputhatch", (Block)emberInputHatch, (ItemBlock)new ItemBlockMachineComponentCustomName((Block)emberInputHatch));
            Registry.registerBlock("blockemberoutputhatch", (Block)emberOutputHatch, (ItemBlock)new ItemBlockMachineComponentCustomName((Block)emberOutputHatch));
        }
        if (ModularDiversity.BotaniaLoaded) {
            BlockManaInputHatch manaInputHatch = new BlockManaInputHatch();
            BlockManaOutputHatch manaOutputHatch = new BlockManaOutputHatch();
            Registry.registerBlock("blockmanainputhatch", (Block)manaInputHatch, (ItemBlock)new ItemBlockMachineComponent((Block)manaInputHatch));
            Registry.registerBlock("blockmanaoutputhatch", (Block)manaOutputHatch, (ItemBlock)new ItemBlockMachineComponent((Block)manaOutputHatch));
        }
        if (ModularDiversity.ImmersivePetroleumLoaded) {
            BlockJackHatch jackHatch = new BlockJackHatch();
            Registry.registerBlock("blockjackhatch", (Block)jackHatch, (ItemBlock)new ItemBlockMachineComponent((Block)jackHatch));
        }
        if (ModularDiversity.BuildcraftLoaded) {
            BlockLaserHatch laserHatch = new BlockLaserHatch();
            Registry.registerBlock("blocklaserhatch", (Block)laserHatch, (ItemBlock)new ItemBlockMachineComponent((Block)laserHatch));
        }
        if (ModularDiversity.BetterWithModsLoaded) {
            BlockMechInputHatch mechInputHatch = new BlockMechInputHatch();
            BlockMechCrankHatch crankInputHatch = new BlockMechCrankHatch();
            BlockMechOutputHatch mechOutputHatch = new BlockMechOutputHatch(1);
            BlockMechOutputHatch mechSteelOutputHatch = new BlockMechOutputHatch(50);
            Registry.registerBlock("blockmechcrankhatch", (Block)crankInputHatch, (ItemBlock)new ItemBlockMachineComponent((Block)crankInputHatch));
            Registry.registerBlock("blockmechinputhatch", (Block)mechInputHatch, (ItemBlock)new ItemBlockMachineComponent((Block)mechInputHatch));
            Registry.registerBlock("blockmechoutputhatch", (Block)mechOutputHatch, (ItemBlock)new ItemBlockMachineComponent((Block)mechOutputHatch));
            Registry.registerBlock("blockmechsteeloutputhatch", (Block)mechSteelOutputHatch, (ItemBlock)new ItemBlockMachineComponent((Block)mechSteelOutputHatch));
        }
        if (ModularDiversity.ProdigyTechLoaded) {
            BlockHotAirInputHatch hotAirInputHatch = new BlockHotAirInputHatch();
            BlockHotAirOutputHatch hotAirOuputHatch = new BlockHotAirOutputHatch();
            Registry.registerBlock("blockhotairinputhatch", (Block)hotAirInputHatch, (ItemBlock)new ItemBlockMachineComponent((Block)hotAirInputHatch));
            Registry.registerBlock("blockhotairoutputhatch", (Block)hotAirOuputHatch, (ItemBlock)new ItemBlockMachineComponent((Block)hotAirOuputHatch));
        }
        if (ModularDiversity.MekanismLoaded) {
            BlockMekLaserAcceptor mekLaserAcceptor = new BlockMekLaserAcceptor();
            BlockMekHeatInput mekHeatInput = new BlockMekHeatInput();
            BlockMekHeatOutput mekHeatOutput = new BlockMekHeatOutput();
            Registry.registerBlock("blockmeklaseracceptor", (Block)mekLaserAcceptor, (ItemBlock)new ItemBlockMachineComponent((Block)mekLaserAcceptor));
            Registry.registerBlock("blockmekheatinput", (Block)mekHeatInput, (ItemBlock)new ItemBlockMachineComponent((Block)mekHeatInput));
            Registry.registerBlock("blockmekheatoutput", (Block)mekHeatOutput, (ItemBlock)new ItemBlockMachineComponent((Block)mekHeatOutput));
        }
        if (ModularDiversity.MysticalMechanicsLoaded) {
            BlockMysticalMechanicsInput mysticalMechanicsInput = new BlockMysticalMechanicsInput();
            BlockMysticalMechanicsOutput mysticalMechanicsOutput = new BlockMysticalMechanicsOutput();
            Registry.registerBlock("blockmystmechinput", (Block)mysticalMechanicsInput, (ItemBlock)new ItemBlockMachineComponent((Block)mysticalMechanicsInput));
            Registry.registerBlock("blockmystmechoutput", (Block)mysticalMechanicsOutput, (ItemBlock)new ItemBlockMachineComponent((Block)mysticalMechanicsOutput));
        }
        BlockBiomeDetector blockBiomeDetector = new BlockBiomeDetector();
        BlockDaylightDetector blockDaylightDetector = new BlockDaylightDetector();
        BlockWeatherDetector blockWeatherDetector = new BlockWeatherDetector();
        Registry.registerBlock("blockbiomedetector", (Block)blockBiomeDetector, (ItemBlock)new ItemBlockMachineComponent((Block)blockBiomeDetector));
        Registry.registerBlock("blockdaylightdetector", (Block)blockDaylightDetector, (ItemBlock)new ItemBlockMachineComponent((Block)blockDaylightDetector));
        Registry.registerBlock("blockweatherdetector", (Block)blockWeatherDetector, (ItemBlock)new ItemBlockMachineComponent((Block)blockWeatherDetector));
    }

    public static void registerBlockModels() {
        for (Block block : BLOCKS) {
            ModularDiversity.proxy.registerBlockModel(block);
        }
    }

    public static void registerItemModels() {
        for (Item item : ITEMS) {
            ModularDiversity.proxy.registerItemModel(item);
        }
    }

    public static void registerBlock(String id, Block block, ItemBlock itemBlock) {
        block.setRegistryName("modulardiversity", id);
        block.func_149663_c(id);
        BLOCKS.add(block);
        Registry.registerItem(id, (Item)itemBlock);
    }

    public static void registerItem(String id, Item item) {
        item.setRegistryName("modulardiversity", id);
        item.func_77655_b(id);
        ITEMS.add(item);
    }

    public static void registerTileEntities() {
        if (ModularDiversity.EmbersLoaded) {
            Registry.registerTileEntity(TileEmberInputHatch.class);
            Registry.registerTileEntity(TileEmberOutputHatch.class);
        }
        if (ModularDiversity.BotaniaLoaded) {
            Registry.registerTileEntity(TileManaInputHatch.class);
            Registry.registerTileEntity(TileManaOutputHatch.class);
        }
        if (ModularDiversity.ImmersivePetroleumLoaded) {
            Registry.registerTileEntity(TileJackHatch.class);
        }
        if (ModularDiversity.BetterWithModsLoaded) {
            Registry.registerTileEntity(TileMechInput.class);
            Registry.registerTileEntity(TileMechInputCrank.class);
            Registry.registerTileEntity(TileMechOutput.class);
        }
        if (ModularDiversity.BuildcraftLoaded) {
            Registry.registerTileEntity(TileLaserInput.class);
        }
        if (ModularDiversity.ProdigyTechLoaded) {
            Registry.registerTileEntity(TileHotAirInput.class);
            Registry.registerTileEntity(TileHotAirOutput.class);
        }
        if (ModularDiversity.MekanismLoaded) {
            Registry.registerTileEntity(TileEntityMekLaserAcceptor.class);
            Registry.registerTileEntity(TileEntityMekHeatInput.class);
            Registry.registerTileEntity(TileEntityMekHeatOutput.class);
        }
        if (ModularDiversity.MysticalMechanicsLoaded) {
            Registry.registerTileEntity(TileMysticalMechanicsInput.class);
            Registry.registerTileEntity(TileMysticalMechanicsOutput.class);
        }
        Registry.registerTileEntity(TileEntityBiomeDetector.class);
        Registry.registerTileEntity(TileEntityDaylightDetector.class);
        Registry.registerTileEntity(TileEntityWeatherDetector.class);
    }

    @SubscribeEvent
    public static void registerComponents(ComponentType.ComponentRegistryEvent event) {
        ComponentType.Registry.register((ComponentType)new ComponentMechanical());
        ComponentType.Registry.register((ComponentType)new ComponentEmber());
        ComponentType.Registry.register((ComponentType)new ComponentMana());
        ComponentType.Registry.register((ComponentType)new ComponentLaser());
        ComponentType.Registry.register((ComponentType)new ComponentHotAir());
        ComponentType.Registry.register((ComponentType)new ComponentMekLaser());
        ComponentType.Registry.register((ComponentType)new ComponentMekHeat());
        ComponentType.Registry.register((ComponentType)new ComponentMysticalMechanics());
        ComponentType.Registry.register((ComponentType)new ComponentBiome());
        ComponentType.Registry.register((ComponentType)new ComponentDaylight());
        ComponentType.Registry.register((ComponentType)new ComponentWeather());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : BLOCKS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    private static void registerTileEntity(Class<? extends TileEntity> tile) {
        GameRegistry.registerTileEntity(tile, (String)tile.getSimpleName().toLowerCase());
    }
}

