/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import primal_tech.configs.ConfigHandler;
import primal_tech.recipes.WoodenBasinRecipes;
import primal_tech.tiles.FluidTankTile;
import primal_tech.tiles.TileEntityInventoryHelper;

public class TileEntityWoodenBasin
extends TileEntityInventoryHelper
implements ITickable {
    public FluidTankTile tank = new FluidTankTile(null, 3000);
    private IItemHandler itemHandler;
    private int stirProgress = 0;
    private int prevStirProgress = 0;
    private int itemBob = 0;
    private int stirCount = 0;
    private boolean countUp = true;
    private boolean mixing = false;

    public TileEntityWoodenBasin() {
        super(4);
        this.tank.setTileEntity(this);
    }

    public void func_73660_a() {
        this.prevStirProgress = this.stirProgress;
        if (this.func_145831_w().field_72995_K) {
            if (this.countUp && this.itemBob <= 20) {
                ++this.itemBob;
                if (this.itemBob == 20) {
                    this.countUp = false;
                }
            }
            if (!this.countUp && this.itemBob >= 0) {
                --this.itemBob;
                if (this.itemBob == 0) {
                    this.countUp = true;
                }
            }
        }
        if (this.getMixing() && this.stirProgress < 90) {
            this.stirProgress += 2;
        }
        if (this.stirProgress >= 90) {
            this.setMixing(false);
            this.stirProgress = 0;
            this.prevStirProgress = 0;
        }
        if (!this.func_145831_w().field_72995_K && this.getStirCount() >= ConfigHandler.WOODEN_BASIN_STIRS && this.tank.getFluidAmount() >= 1000 && this.stirProgress >= 88) {
            ItemStack output = ItemStack.field_190927_a;
            WoodenBasinRecipes recipe = WoodenBasinRecipes.getRecipe((IFluidTank)this.tank, (ItemStack)this.getItems().get(0), (ItemStack)this.getItems().get(1), (ItemStack)this.getItems().get(2), (ItemStack)this.getItems().get(3));
            if (recipe == null) {
                this.setStirCount(0);
                return;
            }
            if (recipe != null) {
                output = recipe.getOutput();
                for (int index = 0; index < 4; ++index) {
                    if (((ItemStack)this.getItems().get(index)).func_190926_b()) continue;
                    this.func_70299_a(index, ItemStack.field_190927_a);
                }
                this.tank.drain(1000, true);
                this.setStirCount(0);
                TileEntityWoodenBasin.spawnItemStack(this.func_145831_w(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                EntityXPOrb orb = new EntityXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1);
                this.field_145850_b.func_72838_d((Entity)orb);
            }
        }
    }

    public static void spawnItemStack(World world, double x, double y, double z, ItemStack stack) {
        EntityItem entityitem = new EntityItem(world, x, y, z, stack);
        entityitem.field_70159_w = 0.0;
        entityitem.field_70181_x = 0.0;
        entityitem.field_70179_y = 0.0;
        entityitem.func_174867_a(20);
        world.func_72838_d((Entity)entityitem);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean getMixing() {
        return this.mixing;
    }

    public void setMixing(boolean mix) {
        this.mixing = mix;
        this.markForUpdate();
    }

    public void setStirCount(int stirs) {
        this.stirCount = stirs;
        this.markForUpdate();
    }

    public int getStirCount() {
        return this.stirCount;
    }

    public int getStirProgress() {
        return this.stirProgress;
    }

    public int getPrevStirProgress() {
        return this.prevStirProgress;
    }

    public int getItemBob() {
        return this.itemBob;
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
        this.tank.onContentsChanged();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        return this.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
        this.mixing = tagCompound.func_74767_n("mixing");
        this.stirCount = tagCompound.func_74762_e("stirCount");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        tagCompound.func_74757_a("mixing", this.getMixing());
        tagCompound.func_74768_a("stirCount", this.stirCount);
        return tagCompound;
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] SLOTS = new int[this.func_70302_i_()];
        for (int index = 0; index < SLOTS.length; ++index) {
            SLOTS[index] = index;
        }
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }
}

