/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.IConditionSource;
import gigaherz.guidebook.guidebook.drawing.Rect;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.drawing.VisualText;
import gigaherz.guidebook.guidebook.elements.Element;
import gigaherz.guidebook.guidebook.elements.ElementParagraph;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementSpan
extends Element {
    public final String text;
    public int color = -16777216;
    public boolean bold;
    public boolean italics;
    public boolean underline;
    public String translationKey = null;
    private ElementParagraph temporaryParagraph = null;

    public ElementSpan(String text, boolean isFirstElement, boolean isLastElement) {
        this.text = ElementSpan.compactString(text, isFirstElement, isLastElement);
    }

    private String getStringWithFormat() {
        String textWithFormat = this.translationKey != null ? I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]) : this.text;
        if (this.bold) {
            textWithFormat = TextFormatting.BOLD + textWithFormat;
        }
        if (this.italics) {
            textWithFormat = TextFormatting.ITALIC + textWithFormat;
        }
        if (this.underline) {
            textWithFormat = TextFormatting.UNDERLINE + textWithFormat;
        }
        return textWithFormat;
    }

    @Override
    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        List<VisualElement> elements = nav.measure(this.getStringWithFormat(), width, firstLineWidth, this.scale, this.position, this.baseline, this.verticalAlignment);
        for (VisualElement text : elements) {
            if (!(text instanceof VisualText)) continue;
            ((VisualText)text).color = this.color;
        }
        return elements;
    }

    @Override
    public int reflow(List<VisualElement> paragraph, IBookGraphics nav, Rect bounds, Rect page) {
        if (this.temporaryParagraph == null) {
            this.temporaryParagraph = new ElementParagraph();
            this.temporaryParagraph.inlines.add(this);
        }
        return this.temporaryParagraph.reflow(paragraph, nav, bounds, page);
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        String text;
        super.parse(book, attributes);
        Node attr = attributes.getNamedItem("bold");
        if (attr != null && ("".equals(text = attr.getTextContent()) || "true".equals(text))) {
            this.bold = true;
        }
        if ((attr = attributes.getNamedItem("italics")) != null && ("".equals(text = attr.getTextContent()) || "true".equals(text))) {
            this.italics = true;
        }
        if ((attr = attributes.getNamedItem("underline")) != null && ("".equals(text = attr.getTextContent()) || "true".equals(text))) {
            this.underline = true;
        }
        if ((attr = attributes.getNamedItem("color")) != null) {
            String c = attr.getTextContent();
            if (c.startsWith("#")) {
                c = c.substring(1);
            }
            try {
                this.color = c.length() <= 6 ? 0xFF000000 | Integer.parseInt(c, 16) : Integer.parseInt(c, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((attr = attributes.getNamedItem("i18n")) != null) {
            this.translationKey = attr.getTextContent();
        }
    }

    @Override
    public Element copy() {
        ElementSpan span = super.copy(new ElementSpan(this.text, false, false));
        span.color = this.color;
        span.bold = this.bold;
        span.italics = this.italics;
        span.underline = this.underline;
        return span;
    }

    public static String compactString(String text, boolean trimLeft, boolean trimRight) {
        String temp = text.replaceAll("[\n\r]+", "").replaceAll("[ \t]+", " ");
        if (trimLeft) {
            temp = temp.replaceAll("^[ \t]+", "");
        }
        if (trimRight) {
            temp = temp.replaceAll("[ \t]+$", "");
        }
        return temp;
    }
}

