/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.IConditionSource;
import gigaherz.guidebook.guidebook.conditions.ConditionContext;
import gigaherz.guidebook.guidebook.drawing.Point;
import gigaherz.guidebook.guidebook.drawing.Rect;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class Element {
    public static final int VA_TOP = 0;
    public static final int VA_MIDDLE = 1;
    public static final int VA_BASELINE = 2;
    public static final int VA_BOTTOM = 3;
    public static final int POS_RELATIVE = 0;
    public static final int POS_ABSOLUTE = 1;
    public static final int POS_FIXED = 2;
    @Nullable
    public int position = 0;
    public int x = 0;
    public int y = 0;
    public int w = 0;
    public int h = 0;
    public int z = 0;
    public float scale = 1.0f;
    public float baseline = 0.7777778f;
    public int verticalAlignment = 2;
    public Predicate<ConditionContext> condition;
    public boolean conditionResult;

    public boolean reevaluateConditions(ConditionContext ctx) {
        boolean oldValue = this.conditionResult;
        this.conditionResult = this.condition == null || this.condition.test(ctx);
        return this.conditionResult != oldValue;
    }

    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        return Collections.emptyList();
    }

    public abstract int reflow(List<VisualElement> var1, IBookGraphics var2, Rect var3, Rect var4);

    public void findTextures(Set<ResourceLocation> textures) {
    }

    public abstract Element copy();

    @Nullable
    public Element applyTemplate(IConditionSource book, List<Element> sourceElements) {
        return this.copy();
    }

    public boolean supportsPageLevel() {
        return false;
    }

    public boolean supportsSpanLevel() {
        return true;
    }

    public Point applyPosition(Point point, Point parent) {
        switch (this.position) {
            case 0: {
                return new Point(point.x + this.x, point.y + this.y);
            }
            case 1: {
                return new Point(parent.x + this.x, parent.y + this.y);
            }
            case 2: {
                return new Point(this.x, this.y);
            }
        }
        return new Point(point.x, point.y);
    }

    protected <T extends Element> T copy(T other) {
        other.position = this.position;
        other.x = this.x;
        other.y = this.y;
        other.z = this.z;
        other.w = this.w;
        other.h = this.h;
        other.scale = this.scale;
        return other;
    }

    public void parse(IConditionSource book, NamedNodeMap attributes) {
        String a;
        Float f;
        Integer i;
        Node attr = attributes.getNamedItem("x");
        if (attr != null) {
            i = Ints.tryParse((String)attr.getTextContent());
            int n = this.x = i != null ? i : 0;
        }
        if ((attr = attributes.getNamedItem("y")) != null) {
            i = Ints.tryParse((String)attr.getTextContent());
            int n = this.y = i != null ? i : 0;
        }
        if ((attr = attributes.getNamedItem("w")) != null) {
            i = Ints.tryParse((String)attr.getTextContent());
            int n = this.w = i != null ? i : 0;
        }
        if ((attr = attributes.getNamedItem("h")) != null) {
            i = Ints.tryParse((String)attr.getTextContent());
            int n = this.h = i != null ? i : 0;
        }
        if ((attr = attributes.getNamedItem("z")) != null) {
            i = Ints.tryParse((String)attr.getTextContent());
            int n = this.z = i != null ? i : 0;
        }
        if ((attr = attributes.getNamedItem("scale")) != null && (f = Floats.tryParse((String)attr.getTextContent())) != null) {
            this.scale = f.floatValue();
        }
        if ((attr = attributes.getNamedItem("align")) != null) {
            switch (a = attr.getTextContent()) {
                case "relative": {
                    this.position = 0;
                    break;
                }
                case "absolute": {
                    this.position = 1;
                    break;
                }
                case "fixed": {
                    this.position = 2;
                }
            }
        }
        if ((attr = attributes.getNamedItem("vertical-align")) != null) {
            switch (a = attr.getTextContent()) {
                case "top": {
                    this.verticalAlignment = 0;
                    break;
                }
                case "middle": {
                    this.verticalAlignment = 1;
                    break;
                }
                case "baseline": {
                    this.verticalAlignment = 2;
                    break;
                }
                case "bottom": {
                    this.verticalAlignment = 3;
                }
            }
        }
        if ((attr = attributes.getNamedItem("baseline")) != null && (f = Floats.tryParse((String)attr.getTextContent())) != null) {
            this.baseline = f.floatValue();
        }
        if ((attr = attributes.getNamedItem("condition")) != null) {
            this.condition = book.getCondition(attr.getTextContent());
        }
    }

    public void parseChildNodes(IConditionSource book, Node element) {
    }
}

