/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.client;

import gigaherz.common.client.ModelHandle;
import gigaherz.common.client.ModelHelpers;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.client.BookRegistryEvent;
import gigaherz.guidebook.common.IModProxy;
import gigaherz.guidebook.guidebook.BookDocument;
import gigaherz.guidebook.guidebook.client.BookBakedModel;
import gigaherz.guidebook.guidebook.client.BookRegistry;
import gigaherz.guidebook.guidebook.client.GuiGuidebook;
import gigaherz.guidebook.guidebook.conditions.AdvancementCondition;
import gigaherz.guidebook.guidebook.conditions.BasicConditions;
import gigaherz.guidebook.guidebook.conditions.CompositeCondition;
import gigaherz.guidebook.guidebook.conditions.GameStageCondition;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="gbook")
public class ClientProxy
implements IModProxy {
    public ClientProxy() {
        BookRegistry.injectCustomResourcePack();
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        OBJLoader.INSTANCE.addDomain("gbook");
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new BookBakedModel.ModelLoader());
        ModelHelpers.registerItemModel((Item)GuidebookMod.guidebook);
    }

    @Override
    public void preInit() {
        ModelHandle.init();
        BasicConditions.register();
        CompositeCondition.register();
        AdvancementCondition.register();
        if (Loader.isModLoaded((String)"gamestages")) {
            GameStageCondition.register();
        }
        MinecraftForge.EVENT_BUS.post((Event)new BookRegistryEvent());
    }

    @Override
    public void registerBook(ResourceLocation bookLocation) {
        BookRegistry.registerBook(bookLocation);
    }

    @Override
    public Collection<ResourceLocation> getBooksList() {
        return BookRegistry.LOADED_BOOKS.keySet();
    }

    @Override
    public void displayBook(String book) {
        ResourceLocation loc = new ResourceLocation(book);
        BookDocument br = BookRegistry.get(loc);
        if (br != null && br.chapterCount() > 0) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiGuidebook(loc));
        }
    }

    @Override
    public String getBookName(String book) {
        String name;
        BookDocument bookDocument = BookRegistry.get(new ResourceLocation(book));
        if (bookDocument != null && (name = bookDocument.getBookName()) != null) {
            return name;
        }
        return String.format("Guidebook - %s unknown", book);
    }
}

