/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.util.noise;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;

public class VoronoiNoiseGenerator {
    final Random rand = new Random();
    final List<BlockPos> points = new ArrayList<BlockPos>();

    public double eval(int cellSize, int x, int z) {
        int cellX = Math.floorDiv(x, cellSize);
        int cellZ = Math.floorDiv(z, cellSize);
        int inCellX = x - cellX * cellSize;
        int inCellZ = z - cellZ * cellSize;
        for (int xI = -1; xI < 2; ++xI) {
            for (int zI = -1; zI < 2; ++zI) {
                this.rand.setSeed((long)(xI + cellX) * 341873128712L + (long)(zI + cellZ) * 132897987541L);
                for (int i = 0; i < 3; ++i) {
                    this.points.add(new BlockPos((xI + cellX) * cellSize + this.rand.nextInt(cellSize), 0, (zI + cellZ) * cellSize + this.rand.nextInt(cellSize)));
                }
            }
        }
        double lowest = 500000.0;
        double secondLowest = 500000.0;
        for (BlockPos pos : this.points) {
            double distance = this.getDistance(pos, cellX * cellSize + inCellX, cellZ * cellSize + inCellZ);
            if (distance < lowest) {
                secondLowest = lowest;
                lowest = distance;
                continue;
            }
            if (!(distance < secondLowest)) continue;
            secondLowest = distance;
        }
        this.points.clear();
        return secondLowest / ((double)cellSize / 0.707);
    }

    public double octaves(int octaves, int cellSize, int x, int y, int z) {
        double total = 0.0;
        int frequency = 1;
        double amplitude = 1.0;
        double maxValue = 0.0;
        for (int i = 0; i < octaves; ++i) {
            total += this.eval(cellSize * frequency, x, y, z) * amplitude;
            maxValue += amplitude;
            amplitude *= 2.0;
            frequency *= 2;
        }
        return total / maxValue;
    }

    public double eval(int cellSize, int x, int blockY, int z) {
        int cellX = Math.floorDiv(x, cellSize);
        int cellZ = Math.floorDiv(z, cellSize);
        int cellY = Math.floorDiv(blockY, cellSize);
        int inCellX = x - cellX * cellSize;
        int inCellY = blockY - cellY * cellSize;
        int inCellZ = z - cellZ * cellSize;
        for (int xI = -1; xI < 2; ++xI) {
            for (int zI = -1; zI < 2; ++zI) {
                for (int y = -1; y < 2; ++y) {
                    this.rand.setSeed((long)(xI + cellX) * 341873128712L + (long)(y + cellY) * 1328977541L + (long)(zI + cellZ) * 132897987541L);
                    for (int i = 0; i < 3; ++i) {
                        this.points.add(new BlockPos((xI + cellX) * cellSize + this.rand.nextInt(cellSize), (y + cellY) * cellSize + this.rand.nextInt(cellSize), (zI + cellZ) * cellSize + this.rand.nextInt(cellSize)));
                    }
                }
            }
        }
        double lowest = 500000.0;
        double secondLowest = 500000.0;
        for (BlockPos pos : this.points) {
            double distance = this.getDistanceSq(pos, cellX * cellSize + inCellX, cellY * cellSize + inCellY, cellZ * cellSize + inCellZ);
            if (distance < lowest) {
                secondLowest = lowest;
                lowest = distance;
                continue;
            }
            if (!(distance < secondLowest)) continue;
            secondLowest = distance;
        }
        this.points.clear();
        return Math.sqrt(secondLowest);
    }

    private double getDistanceSq(BlockPos pos, int x, int z) {
        double d0 = Math.pow(Math.abs((double)(pos.func_177958_n() - x)), 2.0);
        double d2 = Math.pow(Math.abs((double)(pos.func_177952_p() - z)), 2.0);
        return d0 + d2;
    }

    private double getDistance(BlockPos pos, int x, int z) {
        double d0 = Math.pow(Math.abs((double)(pos.func_177958_n() - x)), 2.0);
        double d2 = Math.pow(Math.abs((double)(pos.func_177952_p() - z)), 2.0);
        return Math.sqrt(d0 + d2);
    }

    private double getDistanceSq(BlockPos pos, int x, int y, int z) {
        double d0 = Math.pow(Math.abs((double)(pos.func_177958_n() - x)), 2.0);
        double d1 = Math.pow(Math.abs((double)(pos.func_177956_o() - y)), 2.0);
        double d2 = Math.pow(Math.abs((double)(pos.func_177952_p() - z)), 2.0);
        return d0 + d1 + d2;
    }

    private double getDistance(BlockPos pos, int x, int y, int z) {
        double d0 = Math.pow(Math.abs((double)(pos.func_177958_n() - x)), 2.0);
        double d1 = Math.pow(Math.abs((double)(pos.func_177956_o() - y)), 2.0);
        double d2 = Math.pow(Math.abs((double)(pos.func_177952_p() - z)), 2.0);
        return Math.sqrt(d0 + d1 + d2);
    }
}

