/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config.data;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.MinMaxBoundsData;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/dataObjects/LocationData", classExplaination="These are the functions which can be called on an LocationData object.")
public class LocationData {
    private Biome biome;
    private String feature;
    private DimensionType dimensionType;
    private MinMaxBoundsData x = new MinMaxBoundsData();
    private MinMaxBoundsData y = new MinMaxBoundsData();
    private MinMaxBoundsData z = new MinMaxBoundsData();

    public LocationPredicate buildLocationPredicate() {
        return new LocationPredicate(this.x.buildBounds(), this.y.buildBounds(), this.z.buildBounds(), this.biome, this.feature, this.dimensionType);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max X coordinates.")
    public void setXMinMax(float min, float max) {
        this.x.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min X coordinate.")
    public void setXMin(float min) {
        this.x.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max X coordinate.")
    public void setXMax(float max) {
        this.x.setMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max Y coordinates.")
    public void setYMinMax(float min, float max) {
        this.y.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min Y coordinate.")
    public void setYMin(float min) {
        this.y.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max Y coordinate.")
    public void setYMax(float max) {
        this.y.setMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max Z coordinates.")
    public void setZMinMax(float min, float max) {
        this.z.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min Z coordinate.")
    public void setZMin(float min) {
        this.z.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max Z coordinate.")
    public void setZMax(float max) {
        this.z.setMax(max);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome id", notes="Sets the biome id. Can be an int or String.")
    public void setBiome(int id) {
        Biome biome = Biome.func_185357_a((int)id);
        if (biome != null) {
            this.biome = biome;
        } else {
            DimensionalControl.instance.getLog().error((Object)(id + " is not a registered biome!"));
        }
    }

    @ScriptMethodDocumentation(args="String", usage="feature id", notes="Sets the feature id. Used for things like structures.")
    public void setFeature(String feature) {
        this.feature = feature;
    }

    @ScriptMethodDocumentation(args="String", usage="dimension type", notes="Sets the dimension type. Vanilla options are \"overworld\", \"the_nether\", \"the_end\"")
    public void setDimensionType(String type) {
        DimensionType dType = DimensionType.func_193417_a((String)type);
        if (dType != null) {
            this.dimensionType = dType;
        } else {
            DimensionalControl.instance.getLog().error((Object)(type + " is not a valid dimension type!"));
        }
    }
}

