/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config;

import com.bloodnbonesgaming.dimensionalcontrol.client.gui.GuiDownloadTerrainCustom;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.ArrayList;
import java.util.List;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/ClientConfigs", classExplaination="This object is used for various client-only options. Anything run on this object will be ignored on dedicated servers.")
public class ClientConfigs {
    private final List<GuiDownloadTerrainCustom> loadingScreens = new ArrayList<GuiDownloadTerrainCustom>();

    public GuiDownloadTerrainCustom getLoadingScreen(int toDimension, int fromDimension) {
        GuiDownloadTerrainCustom specificToDimension = null;
        GuiDownloadTerrainCustom specificFromDimension = null;
        GuiDownloadTerrainCustom generic = null;
        for (GuiDownloadTerrainCustom screen : this.loadingScreens) {
            List<Integer> toDimensions = screen.getToDimensions();
            List<Integer> fromDimensions = screen.getFromDimensions();
            boolean specificTo = toDimensions.contains(toDimension);
            boolean specificFrom = fromDimensions.contains(fromDimension);
            if (specificTo && specificFrom) {
                return screen;
            }
            if (specificTo && specificToDimension == null && fromDimensions.isEmpty() || fromDimensions.contains(null)) {
                specificToDimension = screen;
                continue;
            }
            if (specificFrom && specificFromDimension == null && toDimensions.isEmpty() || toDimensions.contains(null)) {
                specificFromDimension = screen;
                continue;
            }
            if (specificTo || specificFrom || generic != null || !toDimensions.isEmpty() && !toDimensions.contains(null) || !fromDimensions.isEmpty() && !fromDimensions.contains(null)) continue;
            generic = screen;
        }
        if (specificToDimension != null) {
            return specificToDimension;
        }
        if (specificFromDimension != null) {
            return specificFromDimension;
        }
        return generic;
    }

    @ScriptMethodDocumentation(usage="", notes="Adds a loading screen which will be used when traveling between any dimensions.")
    public GuiDownloadTerrainCustom newLoadingScreen() {
        GuiDownloadTerrainCustom screen = new GuiDownloadTerrainCustom();
        this.loadingScreens.add(screen);
        return screen;
    }

    @ScriptMethodDocumentation(args="Integer, Integer", usage="toDimension, fromDimension", notes="Adds a loading screen which will be used when traveling between toDimension and fromDimension. Documentation can be found in documentation/gui/LoadingScreen.txt")
    public GuiDownloadTerrainCustom newLoadingScreen(Integer toDimension, Integer fromDimension) {
        GuiDownloadTerrainCustom screen = new GuiDownloadTerrainCustom(toDimension, fromDimension);
        this.loadingScreens.add(screen);
        return screen;
    }

    @ScriptMethodDocumentation(args="int array, Integer", usage="toDimension, fromDimension", notes="Adds a loading screen which will be used when traveling between toDimension and fromDimension. Documentation can be found in documentation/gui/LoadingScreen.txt")
    public GuiDownloadTerrainCustom newLoadingScreen(int[] toDimension, Integer fromDimension) {
        GuiDownloadTerrainCustom screen = new GuiDownloadTerrainCustom(toDimension, fromDimension);
        this.loadingScreens.add(screen);
        return screen;
    }

    @ScriptMethodDocumentation(args="Integer, int array", usage="toDimension, fromDimension", notes="Adds a loading screen which will be used when traveling between toDimension and fromDimension. Documentation can be found in documentation/gui/LoadingScreen.txt")
    public GuiDownloadTerrainCustom newLoadingScreen(Integer toDimension, int[] fromDimension) {
        GuiDownloadTerrainCustom screen = new GuiDownloadTerrainCustom(toDimension, fromDimension);
        this.loadingScreens.add(screen);
        return screen;
    }

    @ScriptMethodDocumentation(args="int array, int array", usage="toDimension, fromDimension", notes="Adds a loading screen which will be used when traveling between toDimension and fromDimension. Documentation can be found in documentation/gui/LoadingScreen.txt")
    public GuiDownloadTerrainCustom newLoadingScreen(int[] toDimension, int[] fromDimension) {
        GuiDownloadTerrainCustom screen = new GuiDownloadTerrainCustom(toDimension, fromDimension);
        this.loadingScreens.add(screen);
        return screen;
    }
}

