/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.blockreplacement;

import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.GenerationPoint;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.WorldServer;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/blockreplacements/BlockReplacement", classExplaination="The role of a BlockReplacement is to handle all instances where you need to replace one block with another. For instance, it can be used to raise or lower the water height, replace oceans with lava, replace leaves with diamond blocks, etc. The key is using the correct GenerationPoint, so that the replacement is done at the right time during generation.")
public class BlockReplacement {
    final List<GenerationPoint> generationPoints = new ArrayList<GenerationPoint>();

    public IBlockState replace(WorldServer world, IBlockState state, int x, int y, int z) {
        return null;
    }

    public boolean shouldRunForLocation(WorldServer world, int x, int y, int z) {
        return false;
    }

    public boolean shouldRunForGenerationPoint(GenerationPoint point) {
        return this.generationPoints.contains((Object)point);
    }

    @ScriptMethodDocumentation(args="String", usage="Generation_Point_ID", notes="Adds a generation point for this block replacement to be run at. Options in order of first to last occurance in generation are: \"BIOME_BLOCK_REPLACEMENT\", \"POPULATE_CHUNK_PRE\", \"DECORATE_CHUNK_PRE\", \"DECORATE_CHUNK_POST\", \"POPULATE_CHUNK_POST\", \"WORLD_GENERATOR_FIRST\", \"WORLD_GENERATOR_LAST\"")
    public void addGenerationPoint(String id) {
        GenerationPoint point = GenerationPoint.valueOf(id.toUpperCase());
        if (point != null) {
            this.addGenerationPoint(point);
        }
    }

    public void addGenerationPoint(GenerationPoint point) {
        this.generationPoints.add(point);
    }
}

