/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import vswe.superfactory.SuperFactoryManager;
import vswe.superfactory.tiles.TileEntityManager;

public class ItemMemoryDisk
extends Item {
    public ItemMemoryDisk() {
        this.func_77637_a(SuperFactoryManager.creativeTab);
        this.func_77655_b("sfm.memorydisk");
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.RED + "WIP");
        if (stack.func_77942_o() && ItemMemoryDisk.validateNBT(stack)) {
            if (stack.func_77978_p().func_74764_b("Author")) {
                tooltip.add("Manager setup authored by:");
                tooltip.add(stack.func_77978_p().func_74779_i("Author"));
            } else {
                int x = stack.func_77978_p().func_74762_e("x");
                int y = stack.func_77978_p().func_74762_e("y");
                int z = stack.func_77978_p().func_74762_e("z");
                tooltip.add("Data stored from Manager at:");
                tooltip.add("x: " + x + " y: " + y + " z: " + z);
            }
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af() && (te = world.func_175625_s(pos)) instanceof TileEntityManager) {
            if (stack.func_77942_o() && ItemMemoryDisk.validateNBT(stack)) {
                te.func_145839_a(ItemMemoryDisk.correctNBT((TileEntityManager)te, stack.func_77978_p()));
                stack.func_77982_d(null);
                return EnumActionResult.PASS;
            }
            NBTTagCompound tagCompound = new NBTTagCompound();
            te.func_189515_b(tagCompound);
            tagCompound.func_74782_a("ench", (NBTBase)new NBTTagList());
            stack.func_77982_d(tagCompound);
            return EnumActionResult.PASS;
        }
        ItemMemoryDisk.validateNBT(stack);
        return EnumActionResult.PASS;
    }

    public static boolean validateNBT(ItemStack stack) {
        return stack.func_77942_o() && (stack.func_77978_p().func_74779_i("id").equals("TileEntityMachineManagerName") || stack.func_77978_p().func_74779_i("id").equals("TileEntityRFManager"));
    }

    private static NBTTagCompound correctNBT(TileEntityManager manager, NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("x", manager.func_174877_v().func_177958_n());
        tagCompound.func_74768_a("y", manager.func_174877_v().func_177956_o());
        tagCompound.func_74768_a("z", manager.func_174877_v().func_177952_p());
        int currentFlow = manager.getFlowItems().size();
        if (currentFlow > 0) {
            byte version = tagCompound.func_74771_c("ProtocolVersion");
            NBTTagList components = tagCompound.func_150295_c("Components", 10);
            NBTTagList newComponents = new NBTTagList();
            for (int variablesTag = 0; variablesTag < components.func_74745_c(); ++variablesTag) {
                NBTTagCompound flowComponent = components.func_150305_b(variablesTag);
                NBTTagList connections = flowComponent.func_150295_c("Connection", 10);
                NBTTagList newConnections = new NBTTagList();
                for (int i = 0; i < connections.func_74745_c(); ++i) {
                    NBTTagCompound connection = connections.func_150305_b(i);
                    if (connection.func_74764_b("ConnectionComponent")) {
                        if (version < 9) {
                            connection.func_74774_a("ConnectionComponent", (byte)(connection.func_74771_c("ConnectionComponent") + currentFlow));
                        } else {
                            connection.func_74777_a("ConnectionComponent", (short)(connection.func_74765_d("ConnectionComponent") + currentFlow));
                        }
                    }
                    newConnections.func_74742_a((NBTBase)connection);
                }
                flowComponent.func_74782_a("Connection", (NBTBase)newConnections);
                newComponents.func_74742_a((NBTBase)flowComponent);
            }
            tagCompound.func_74782_a("Components", (NBTBase)newComponents);
        }
        return tagCompound;
    }
}

