/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import vswe.superfactory.CollisionHelper;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.Connection;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuGroup
extends ComponentMenu {
    private static final int MENU_WIDTH = 120;
    private static final int TEXT_MARGIN_X = 5;
    private static final int TEXT_Y = 5;

    public ComponentMenuGroup(FlowComponent parent) {
        super(parent);
    }

    public static void moveComponents(FlowComponent component, FlowComponent parent, boolean moveCluster) {
        if (moveCluster) {
            ArrayList<FlowComponent> cluster = new ArrayList<FlowComponent>();
            ComponentMenuGroup.findCluster(cluster, component, parent);
            for (FlowComponent flowComponent : cluster) {
                flowComponent.setParent(parent);
                if (parent == null) continue;
                for (int i = 0; i < flowComponent.getConnectionSet().getConnections().length; ++i) {
                    Connection connection = flowComponent.getConnection(i);
                    if (connection == null || connection.getComponentId() != parent.getId()) continue;
                    flowComponent.removeConnection(i);
                }
            }
        } else if (!component.equals(parent)) {
            component.setParent(parent);
            component.removeAllConnections();
        }
    }

    private static void findCluster(List<FlowComponent> components, FlowComponent component, FlowComponent parent) {
        if (!components.contains(component) && !component.equals(parent)) {
            components.add(component);
            for (int i = 0; i < component.getConnectionSet().getConnections().length; ++i) {
                Connection connection = component.getConnection(i);
                if (connection == null) continue;
                ComponentMenuGroup.findCluster(components, component.getManager().getFlowItems().get(connection.getComponentId()), parent);
            }
        }
    }

    @Override
    public String getName() {
        return Localization.GROUP_MENU.toString();
    }

    @Override
    public void draw(GuiManager gui, int mX, int mY) {
        gui.drawSplitString(Localization.GROUP_INFO.toString(), 5, 5, 110, 1.0f, 0x404040);
    }

    @Override
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        if (this.inBounds(mX, mY)) {
            this.getParent().getManager().setSelectedComponent(this.getParent());
        }
    }

    private boolean inBounds(int mX, int mY) {
        return CollisionHelper.inBounds(0, 0, 120, FlowComponent.getMenuOpenSize(), mX, mY);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
        if (isMenuOpen && this.inBounds(mX, mY)) {
            for (FlowComponent component : this.getParent().getManager().getFlowItems()) {
                if (!component.isBeingMoved()) continue;
                if (component.equals(this.getParent())) break;
                DataWriter dw = this.getWriterForServerComponentPacket();
                dw.writeComponentId(this.getParent().getManager(), component.getId());
                dw.writeBoolean(GuiScreen.func_146272_n());
                PacketHandler.sendDataToServer(dw);
                break;
            }
        }
    }

    @Override
    public void writeData(DataWriter dw) {
    }

    @Override
    public void readData(DataReader dr) {
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        if (!this.getParent().getManager().func_145831_w().field_72995_K) {
            int id = dr.readComponentId();
            FlowComponent component = this.getParent().getManager().getFlowItems().get(id);
            boolean moveCluster = dr.readBoolean();
            ComponentMenuGroup.moveComponents(component, this.getParent(), moveCluster);
        }
    }
}

