/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.blocks;

import javax.annotation.Nonnull;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.blocks.BlockBarrelBase;
import knightminer.ceramics.library.Config;
import knightminer.ceramics.library.IFaucetDepthFallback;
import knightminer.ceramics.library.Util;
import knightminer.ceramics.tileentity.TileBarrel;
import knightminer.ceramics.tileentity.TileBarrelBase;
import knightminer.ceramics.tileentity.TileBarrelExtension;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import slimeknights.tconstruct.library.smeltery.IFaucetDepth;

@Optional.Interface(iface="slimeknights.tconstruct.library.smeltery.IFaucetDepth", modid="tconstruct")
public class BlockBarrel
extends BlockBarrelBase
implements ITileEntityProvider,
IFaucetDepth,
IFaucetDepthFallback {
    public BlockBarrel(Material material) {
        super(material);
        this.field_149758_A = true;
        this.func_149711_c(1.25f);
        this.func_149752_b(7.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(Ceramics.tab);
    }

    public BlockBarrel() {
        this(Material.field_151576_e);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)EXTENSION, (Comparable)Boolean.FALSE));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this.isExtension(this.func_176203_a(meta))) {
            return new TileBarrelExtension();
        }
        return new TileBarrel(1000 * Config.barrelClayCapacity);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBarrel) {
            ((TileBarrel)te).checkBarrelStructure();
        } else {
            te = world.func_175625_s(pos.func_177977_b());
            if (te instanceof TileBarrelBase) {
                ((TileBarrelBase)te).checkBarrelStructure();
            }
        }
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileBarrelExtension) {
            ((TileBarrelExtension)te).checkBarrelStructure();
        }
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return false;
        }
        IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        boolean success = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
        if (!world.field_72995_K) {
            FluidStack fluid = fluidHandler.getTankProperties()[0].getContents();
            if (fluid == null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation(Util.prefix("barrel.fluid.empty"), new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation(Util.prefix("barrel.fluid.amount"), new Object[]{fluid.amount, fluid.getLocalizedName()}), true);
            }
        }
        return success || FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null;
    }

    public void func_176224_k(World world, BlockPos pos) {
        TileEntity te;
        float f = world.func_180494_b(pos).func_180626_a(pos);
        if (world.func_72959_q().func_76939_a(f, pos.func_177956_o()) >= 0.15f && (te = world.func_175625_s(pos)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) {
            IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
            fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 100), true);
        }
    }

    public boolean isValidExtension(IBlockState state) {
        return state.func_177230_c() == Ceramics.clayBarrel && (Boolean)state.func_177229_b((IProperty)EXTENSION) != false || state.func_177230_c() == Ceramics.clayBarrelStainedExtension;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EXTENSION});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta == 1) {
            state = state.func_177226_a((IProperty)EXTENSION, (Comparable)Boolean.TRUE);
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)EXTENSION)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (Config.barrelEnabled) {
            list.add((Object)new ItemStack((Block)this, 1, 0));
            list.add((Object)new ItemStack((Block)this, 1, 1));
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return !this.isExtension(state);
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBarrel) {
            return ((TileBarrel)te).comparatorStrength();
        }
        return 0;
    }

    @Override
    public float getFlowDepth(World world, BlockPos pos, IBlockState state) {
        if (this.isExtension(state)) {
            BlockPos master;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileBarrelExtension && (master = ((TileBarrelExtension)te).getMasterPos()) != null) {
                return 0.9375f + (float)pos.func_177956_o() - (float)master.func_177956_o();
            }
            return 1.0f;
        }
        return 0.9375f;
    }
}

